/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model;

import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.webkit.URLUtil;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.vungle.warren.AdConfig;
import com.vungle.warren.model.JsonUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import okhttp3.HttpUrl;
import org.json.JSONException;
import org.json.JSONObject;

public class Advertisement {
    private static final String TAG = "Advertisement";
    private static final String FILE_SCHEME = "file://";
    static final String START_MUTED = "START_MUTED";
    private static final String UNKNOWN = "unknown";
    public static final int TYPE_VUNGLE_LOCAL = 0;
    public static final int TYPE_VUNGLE_MRAID = 1;
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    public static final String KEY_POSTROLL = "postroll";
    public static final String KEY_VIDEO = "video";
    public static final String KEY_TEMPLATE = "template";
    public static final int NEW = 0;
    public static final int READY = 1;
    public static final int VIEWING = 2;
    public static final int DONE = 3;
    public static final int ERROR = 4;
    @AdType
    int adType;
    String identifier;
    String appID;
    long expireTime;
    List<Checkpoint> checkpoints;
    String[] muteUrls;
    String[] unmuteUrls;
    String[] closeUrls;
    String[] postRollClickUrls;
    String[] postRollViewUrls;
    String[] clickUrls;
    String[] videoClickUrls;
    int delay;
    String campaign;
    int showCloseDelay;
    int showCloseIncentivized;
    int countdown;
    String videoUrl;
    int videoWidth;
    int videoHeight;
    String md5;
    String postrollBundleUrl;
    boolean ctaOverlayEnabled;
    boolean ctaClickArea = true;
    String ctaDestinationUrl;
    String ctaUrl;
    AdConfig adConfig;
    int retryCount;
    String adToken;
    String videoIdentifier;
    String templateUrl;
    Map<String, String> templateSettings;
    Map<String, String> mraidFiles = new HashMap<String, String>();
    Map<String, Pair<String, String>> cacheableAssets = new HashMap<String, Pair<String, String>>();
    String templateId;
    String templateType;
    boolean enableMoat;
    String moatExtraVast;
    boolean requiresNonMarketInstall;
    String adMarketId;
    String bidToken;
    int state = 0;
    String placementId;
    long ttDownload;

    Advertisement() {
    }

    public long getTtDownload() {
        return this.ttDownload;
    }

    public void setTtDownload(long ttDownload) {
        this.ttDownload = ttDownload;
    }

    public String getPlacementId() {
        return this.placementId;
    }

    public void setPlacementId(String placementId) {
        this.placementId = placementId;
    }

    public boolean isCtaOverlayEnabled() {
        return this.ctaOverlayEnabled;
    }

    public boolean getCtaClickArea() {
        return this.ctaClickArea;
    }

    public boolean isRequiresNonMarketInstall() {
        return this.requiresNonMarketInstall;
    }

    public Advertisement(@NonNull JsonObject json) throws IllegalArgumentException {
        long expire;
        if (!JsonUtil.hasNonNull((JsonElement)json, "ad_markup")) {
            throw new IllegalArgumentException("JSON does not contain ad markup!");
        }
        JsonObject adMarkup = json.getAsJsonObject("ad_markup");
        String tempVideoUrl = "";
        if (JsonUtil.hasNonNull((JsonElement)adMarkup, "adType")) {
            String adTypeRaw;
            switch (adTypeRaw = adMarkup.get("adType").getAsString()) {
                case "vungle_local": {
                    this.adType = 0;
                    String string = this.postrollBundleUrl = JsonUtil.hasNonNull((JsonElement)adMarkup, "postBundle") ? adMarkup.get("postBundle").getAsString() : "";
                    if (JsonUtil.hasNonNull((JsonElement)adMarkup, "url")) {
                        tempVideoUrl = adMarkup.get("url").getAsString();
                    }
                    this.templateSettings = new HashMap<String, String>();
                    this.templateUrl = "";
                    this.templateId = "";
                    this.templateType = "";
                    break;
                }
                case "vungle_mraid": {
                    this.adType = 1;
                    this.postrollBundleUrl = "";
                    if (JsonUtil.hasNonNull((JsonElement)adMarkup, "templateSettings")) {
                        this.templateSettings = new HashMap<String, String>();
                        JsonObject templateJson = adMarkup.getAsJsonObject("templateSettings");
                        if (JsonUtil.hasNonNull((JsonElement)templateJson, "normal_replacements")) {
                            JsonObject normalReplacements = templateJson.getAsJsonObject("normal_replacements");
                            for (Map.Entry element : normalReplacements.entrySet()) {
                                if (TextUtils.isEmpty((CharSequence)((CharSequence)element.getKey()))) continue;
                                String value = element.getValue() == null || ((JsonElement)element.getValue()).isJsonNull() ? null : ((JsonElement)element.getValue()).getAsString();
                                this.templateSettings.put((String)element.getKey(), value);
                            }
                        }
                        if (JsonUtil.hasNonNull((JsonElement)templateJson, "cacheable_replacements")) {
                            JsonObject cacheable = templateJson.getAsJsonObject("cacheable_replacements");
                            for (Map.Entry element : cacheable.entrySet()) {
                                if (TextUtils.isEmpty((CharSequence)((CharSequence)element.getKey())) || element.getValue() == null || !JsonUtil.hasNonNull((JsonElement)element.getValue(), "url") || !JsonUtil.hasNonNull((JsonElement)element.getValue(), "extension")) continue;
                                String url = ((JsonElement)element.getValue()).getAsJsonObject().get("url").getAsString();
                                String ext = ((JsonElement)element.getValue()).getAsJsonObject().get("extension").getAsString();
                                this.cacheableAssets.put((String)element.getKey(), (Pair<String, String>)new Pair((Object)url, (Object)ext));
                                if (!((String)element.getKey()).equalsIgnoreCase("MAIN_VIDEO")) continue;
                                tempVideoUrl = url;
                            }
                        }
                    } else {
                        throw new IllegalArgumentException("Missing template adConfig!");
                    }
                    if (!JsonUtil.hasNonNull((JsonElement)adMarkup, "templateId")) {
                        throw new IllegalArgumentException("Missing templateID!");
                    }
                    this.templateId = adMarkup.get("templateId").getAsString();
                    if (!JsonUtil.hasNonNull((JsonElement)adMarkup, "template_type")) {
                        throw new IllegalArgumentException("Template Type missing!");
                    }
                    this.templateType = adMarkup.get("template_type").getAsString();
                    if (JsonUtil.hasNonNull((JsonElement)adMarkup, "templateURL")) {
                        this.templateUrl = adMarkup.get("templateURL").getAsString();
                        break;
                    }
                    throw new IllegalArgumentException("Template URL missing!");
                }
                default: {
                    throw new IllegalArgumentException("Unknown Ad Type " + adTypeRaw + "! Please add this ad type");
                }
            }
        } else {
            throw new IllegalArgumentException("Advertisement did not contain an adType!");
        }
        this.videoUrl = !TextUtils.isEmpty((CharSequence)tempVideoUrl) ? tempVideoUrl : "";
        if (!JsonUtil.hasNonNull((JsonElement)adMarkup, "id")) {
            throw new IllegalArgumentException("Missing identifier, cannot process advertisement!");
        }
        this.identifier = adMarkup.get("id").getAsString();
        if (!JsonUtil.hasNonNull((JsonElement)adMarkup, "campaign")) {
            throw new IllegalArgumentException("Missing campaign information, cannot process advertisement!");
        }
        this.campaign = adMarkup.get("campaign").getAsString();
        if (!JsonUtil.hasNonNull((JsonElement)adMarkup, "app_id")) {
            throw new IllegalArgumentException("Missing app Id, cannot process advertisement!");
        }
        this.appID = adMarkup.get("app_id").getAsString();
        this.expireTime = JsonUtil.hasNonNull((JsonElement)adMarkup, "expiry") && !adMarkup.get("expiry").isJsonNull() ? ((expire = adMarkup.get("expiry").getAsLong()) > 0L ? expire : System.currentTimeMillis() / 1000L) : System.currentTimeMillis() / 1000L;
        if (JsonUtil.hasNonNull((JsonElement)adMarkup, "tpat")) {
            JsonArray urls;
            String viewKey;
            String clickKey;
            String closeKey;
            String unmuteKey;
            String muteKey;
            int x;
            JsonObject tpat = adMarkup.getAsJsonObject("tpat");
            this.checkpoints = new ArrayList<Checkpoint>(5);
            switch (this.adType) {
                case 0: {
                    if (!JsonUtil.hasNonNull((JsonElement)tpat, "play_percentage")) break;
                    JsonArray checkpointData = tpat.getAsJsonArray("play_percentage");
                    for (x = 0; x < checkpointData.size(); ++x) {
                        if (checkpointData.get(x) == null) continue;
                        this.checkpoints.add(new Checkpoint(checkpointData.get(x).getAsJsonObject()));
                    }
                    Collections.sort(this.checkpoints);
                    break;
                }
                case 1: {
                    String checkpoint = null;
                    for (x = 0; x < 5; ++x) {
                        int percent = x * 25;
                        checkpoint = String.format(Locale.ENGLISH, "checkpoint.%d", percent);
                        Checkpoint cpoint = null;
                        if (JsonUtil.hasNonNull((JsonElement)tpat, checkpoint)) {
                            cpoint = new Checkpoint(tpat.getAsJsonArray(checkpoint), (byte)percent);
                        }
                        this.checkpoints.add(x, cpoint);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Ad Type!");
                }
            }
            if (JsonUtil.hasNonNull((JsonElement)tpat, "clickUrl")) {
                JsonArray clickUrlsJon = tpat.getAsJsonArray("clickUrl");
                this.clickUrls = new String[clickUrlsJon.size()];
                x = 0;
                for (JsonElement element : clickUrlsJon) {
                    this.clickUrls[x++] = element.getAsString();
                }
            } else {
                this.clickUrls = new String[0];
            }
            if (JsonUtil.hasNonNull((JsonElement)tpat, "moat")) {
                JsonObject moatObject = tpat.getAsJsonObject("moat");
                this.enableMoat = moatObject.get("is_enabled").getAsBoolean();
                this.moatExtraVast = moatObject.get("extra_vast").getAsString();
            } else {
                this.enableMoat = false;
                this.moatExtraVast = "";
            }
            if (JsonUtil.hasNonNull((JsonElement)tpat, "video_click")) {
                JsonArray urls2 = tpat.getAsJsonArray("video_click");
                this.videoClickUrls = new String[urls2.size()];
                for (x = 0; x < urls2.size(); ++x) {
                    this.videoClickUrls[x] = null == urls2.get(x) || "null".equalsIgnoreCase(urls2.get(x).toString()) ? "" : urls2.get(x).getAsString();
                }
            } else {
                this.videoClickUrls = new String[0];
            }
            switch (this.adType) {
                case 0: {
                    muteKey = "mute";
                    unmuteKey = "unmute";
                    closeKey = "video_close";
                    clickKey = "postroll_click";
                    viewKey = "postroll_view";
                    break;
                }
                case 1: {
                    muteKey = "video.mute";
                    unmuteKey = "video.unmute";
                    closeKey = "video.close";
                    clickKey = "postroll.click";
                    viewKey = "postroll.view";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown AdType!");
                }
            }
            if (JsonUtil.hasNonNull((JsonElement)tpat, muteKey)) {
                urls = tpat.getAsJsonArray(muteKey);
                this.muteUrls = new String[urls.size()];
                for (int x2 = 0; x2 < urls.size(); ++x2) {
                    this.muteUrls[x2] = null == urls.get(x2) || "null".equalsIgnoreCase(urls.get(x2).toString()) ? "" : urls.get(x2).getAsString();
                }
            } else {
                this.muteUrls = new String[0];
            }
            if (JsonUtil.hasNonNull((JsonElement)tpat, unmuteKey)) {
                urls = tpat.getAsJsonArray(unmuteKey);
                this.unmuteUrls = new String[urls.size()];
                for (int x3 = 0; x3 < urls.size(); ++x3) {
                    this.unmuteUrls[x3] = null == urls.get(x3) || "null".equalsIgnoreCase(urls.get(x3).toString()) ? "" : urls.get(x3).getAsString();
                }
            } else {
                this.unmuteUrls = new String[0];
            }
            if (JsonUtil.hasNonNull((JsonElement)tpat, closeKey)) {
                urls = tpat.getAsJsonArray(closeKey);
                this.closeUrls = new String[urls.size()];
                for (int x4 = 0; x4 < urls.size(); ++x4) {
                    this.closeUrls[x4] = null == urls.get(x4) || "null".equalsIgnoreCase(urls.get(x4).toString()) ? "" : urls.get(x4).getAsString();
                }
            } else {
                this.closeUrls = new String[0];
            }
            if (JsonUtil.hasNonNull((JsonElement)tpat, clickKey)) {
                urls = tpat.getAsJsonArray(clickKey);
                this.postRollClickUrls = new String[urls.size()];
                for (int x5 = 0; x5 < urls.size(); ++x5) {
                    this.postRollClickUrls[x5] = null == urls.get(x5) || "null".equalsIgnoreCase(urls.get(x5).toString()) ? "" : urls.get(x5).getAsString();
                }
            } else {
                this.postRollClickUrls = new String[0];
            }
            if (JsonUtil.hasNonNull((JsonElement)tpat, viewKey)) {
                urls = tpat.getAsJsonArray(viewKey);
                this.postRollViewUrls = new String[urls.size()];
                for (int x6 = 0; x6 < urls.size(); ++x6) {
                    this.postRollViewUrls[x6] = null == urls.get(x6) || "null".equalsIgnoreCase(urls.get(x6).toString()) ? "" : urls.get(x6).getAsString();
                }
            } else {
                this.postRollViewUrls = new String[0];
            }
        } else {
            this.checkpoints = new ArrayList<Checkpoint>();
            this.muteUrls = new String[0];
            this.closeUrls = new String[0];
            this.unmuteUrls = new String[0];
            this.postRollViewUrls = new String[0];
            this.postRollClickUrls = new String[0];
            this.clickUrls = new String[0];
            this.videoClickUrls = new String[0];
            this.enableMoat = false;
            this.moatExtraVast = "";
        }
        this.delay = JsonUtil.hasNonNull((JsonElement)adMarkup, "delay") ? adMarkup.get("delay").getAsInt() : 0;
        this.showCloseDelay = JsonUtil.hasNonNull((JsonElement)adMarkup, "showClose") ? adMarkup.get("showClose").getAsInt() : 0;
        this.showCloseIncentivized = JsonUtil.hasNonNull((JsonElement)adMarkup, "showCloseIncentivized") ? adMarkup.get("showCloseIncentivized").getAsInt() : 0;
        this.countdown = JsonUtil.hasNonNull((JsonElement)adMarkup, "countdown") ? adMarkup.get("countdown").getAsInt() : 0;
        if (!JsonUtil.hasNonNull((JsonElement)adMarkup, "videoWidth")) {
            throw new IllegalArgumentException("Missing video width!");
        }
        this.videoWidth = adMarkup.get("videoWidth").getAsInt();
        if (!JsonUtil.hasNonNull((JsonElement)adMarkup, "videoHeight")) {
            throw new IllegalArgumentException("Missing video height!");
        }
        this.videoHeight = adMarkup.get("videoHeight").getAsInt();
        this.md5 = JsonUtil.hasNonNull((JsonElement)adMarkup, "md5") ? adMarkup.get("md5").getAsString() : "";
        if (JsonUtil.hasNonNull((JsonElement)adMarkup, "cta_overlay")) {
            JsonObject cta = adMarkup.getAsJsonObject("cta_overlay");
            this.ctaOverlayEnabled = JsonUtil.hasNonNull((JsonElement)cta, "enabled") ? cta.get("enabled").getAsBoolean() : false;
            if (JsonUtil.hasNonNull((JsonElement)cta, "click_area") && !cta.get("click_area").getAsString().isEmpty() && cta.get("click_area").getAsDouble() == 0.0) {
                this.ctaClickArea = false;
            }
        } else {
            this.ctaOverlayEnabled = false;
        }
        this.ctaDestinationUrl = JsonUtil.hasNonNull((JsonElement)adMarkup, "callToActionDest") ? adMarkup.get("callToActionDest").getAsString() : "";
        this.ctaUrl = JsonUtil.hasNonNull((JsonElement)adMarkup, "callToActionUrl") ? adMarkup.get("callToActionUrl").getAsString() : "";
        this.retryCount = JsonUtil.hasNonNull((JsonElement)adMarkup, "retryCount") ? adMarkup.get("retryCount").getAsInt() : 1;
        if (!JsonUtil.hasNonNull((JsonElement)adMarkup, "ad_token")) {
            throw new IllegalArgumentException("AdToken missing!");
        }
        this.adToken = adMarkup.get("ad_token").getAsString();
        this.videoIdentifier = JsonUtil.hasNonNull((JsonElement)adMarkup, "video_object_id") ? adMarkup.get("video_object_id").getAsString() : "";
        this.requiresNonMarketInstall = JsonUtil.hasNonNull((JsonElement)adMarkup, "requires_sideloading") ? adMarkup.get("requires_sideloading").getAsBoolean() : false;
        this.adMarketId = JsonUtil.hasNonNull((JsonElement)adMarkup, "ad_market_id") ? adMarkup.get("ad_market_id").getAsString() : "";
        this.bidToken = JsonUtil.hasNonNull((JsonElement)adMarkup, "bid_token") ? adMarkup.get("bid_token").getAsString() : "";
        this.adConfig = new AdConfig();
    }

    @AdType
    public int getAdType() {
        return this.adType;
    }

    public List<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    public void configure(AdConfig settings) {
        this.adConfig = settings == null ? new AdConfig() : settings;
    }

    public AdConfig getAdConfig() {
        return this.adConfig;
    }

    @Orientation
    public int getOrientation() {
        if (this.videoWidth > this.videoHeight) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        int x;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Advertisement)) {
            return false;
        }
        Advertisement wrap = (Advertisement)obj;
        if (wrap.adType != this.adType) {
            return false;
        }
        if (wrap.delay != this.delay) {
            return false;
        }
        if (wrap.showCloseDelay != this.showCloseDelay) {
            return false;
        }
        if (wrap.showCloseIncentivized != this.showCloseIncentivized) {
            return false;
        }
        if (wrap.countdown != this.countdown) {
            return false;
        }
        if (wrap.videoWidth != this.videoWidth) {
            return false;
        }
        if (wrap.videoHeight != this.videoHeight) {
            return false;
        }
        if (wrap.ctaOverlayEnabled != this.ctaOverlayEnabled) {
            return false;
        }
        if (wrap.ctaClickArea != this.ctaClickArea) {
            return false;
        }
        if (wrap.retryCount != this.retryCount) {
            return false;
        }
        if (wrap.enableMoat != this.enableMoat) {
            return false;
        }
        if (wrap.requiresNonMarketInstall != this.requiresNonMarketInstall) {
            return false;
        }
        if (wrap.state != this.state) {
            return false;
        }
        if (wrap.identifier == null || this.identifier == null) {
            return false;
        }
        if (!wrap.identifier.equals(this.identifier)) {
            return false;
        }
        if (!wrap.campaign.equals(this.campaign)) {
            return false;
        }
        if (!wrap.videoUrl.equals(this.videoUrl)) {
            return false;
        }
        if (!wrap.md5.equals(this.md5)) {
            return false;
        }
        if (!wrap.postrollBundleUrl.equals(this.postrollBundleUrl)) {
            return false;
        }
        if (!wrap.ctaDestinationUrl.equals(this.ctaDestinationUrl)) {
            return false;
        }
        if (!wrap.ctaUrl.equals(this.ctaUrl)) {
            return false;
        }
        if (!wrap.adToken.equals(this.adToken)) {
            return false;
        }
        if (!wrap.videoIdentifier.equals(this.videoIdentifier)) {
            return false;
        }
        if (!wrap.moatExtraVast.equals(this.moatExtraVast)) {
            return false;
        }
        if (!wrap.adMarketId.equals(this.adMarketId)) {
            return false;
        }
        if (!wrap.bidToken.equals(this.bidToken)) {
            return false;
        }
        if (wrap.checkpoints.size() != this.checkpoints.size()) {
            return false;
        }
        for (x = 0; x < this.checkpoints.size(); ++x) {
            if (wrap.checkpoints.get(x).equals(this.checkpoints.get(x))) continue;
            return false;
        }
        if (wrap.muteUrls.length != this.muteUrls.length) {
            return false;
        }
        for (x = 0; x < this.muteUrls.length; ++x) {
            if (wrap.muteUrls[x].equals(this.muteUrls[x])) continue;
            return false;
        }
        if (wrap.unmuteUrls.length != this.unmuteUrls.length) {
            return false;
        }
        for (x = 0; x < this.unmuteUrls.length; ++x) {
            if (wrap.unmuteUrls[x].equals(this.unmuteUrls[x])) continue;
            return false;
        }
        if (wrap.closeUrls.length != this.closeUrls.length) {
            return false;
        }
        for (x = 0; x < this.closeUrls.length; ++x) {
            if (wrap.closeUrls[x].equals(this.closeUrls[x])) continue;
            return false;
        }
        if (wrap.postRollClickUrls.length != this.postRollClickUrls.length) {
            return false;
        }
        for (x = 0; x < this.postRollClickUrls.length; ++x) {
            if (wrap.postRollClickUrls[x].equals(this.postRollClickUrls[x])) continue;
            return false;
        }
        if (wrap.postRollViewUrls.length != this.postRollViewUrls.length) {
            return false;
        }
        for (x = 0; x < this.postRollViewUrls.length; ++x) {
            if (wrap.postRollViewUrls[x].equals(this.postRollViewUrls[x])) continue;
            return false;
        }
        if (wrap.videoClickUrls.length != this.videoClickUrls.length) {
            return false;
        }
        for (x = 0; x < this.videoClickUrls.length; ++x) {
            if (wrap.videoClickUrls[x].equals(this.videoClickUrls[x])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.adType;
        result = 31 * result + this.identifier.hashCode();
        result = 31 * result + this.checkpoints.hashCode();
        result = 31 * result + Arrays.hashCode(this.muteUrls);
        result = 31 * result + Arrays.hashCode(this.unmuteUrls);
        result = 31 * result + Arrays.hashCode(this.closeUrls);
        result = 31 * result + Arrays.hashCode(this.postRollClickUrls);
        result = 31 * result + Arrays.hashCode(this.postRollViewUrls);
        result = 31 * result + Arrays.hashCode(this.videoClickUrls);
        result = 31 * result + this.delay;
        result = 31 * result + this.campaign.hashCode();
        result = 31 * result + this.showCloseDelay;
        result = 31 * result + this.showCloseIncentivized;
        result = 31 * result + this.countdown;
        result = 31 * result + this.videoUrl.hashCode();
        result = 31 * result + this.videoWidth;
        result = 31 * result + this.videoHeight;
        result = 31 * result + this.md5.hashCode();
        result = 31 * result + this.postrollBundleUrl.hashCode();
        result = 31 * result + (this.ctaOverlayEnabled ? 1 : 0);
        result = 31 * result + (this.ctaClickArea ? 1 : 0);
        result = 31 * result + this.ctaDestinationUrl.hashCode();
        result = 31 * result + this.ctaUrl.hashCode();
        result = 31 * result + this.retryCount;
        result = 31 * result + this.adToken.hashCode();
        result = 31 * result + this.videoIdentifier.hashCode();
        result = 31 * result + (this.enableMoat ? 1 : 0);
        result = 31 * result + this.moatExtraVast.hashCode();
        result = 31 * result + (this.requiresNonMarketInstall ? 1 : 0);
        result = 31 * result + this.adMarketId.hashCode();
        result = 31 * result + this.bidToken.hashCode();
        result = 31 * result + this.state;
        return result;
    }

    public String[] getTpatUrls(@NonNull String event) {
        switch (this.adType) {
            case 0: {
                switch (event) {
                    case "postroll_view": {
                        return (String[])this.postRollViewUrls.clone();
                    }
                    case "postroll_click": {
                        return (String[])this.postRollClickUrls.clone();
                    }
                    case "mute": {
                        return (String[])this.muteUrls.clone();
                    }
                    case "unmute": {
                        return (String[])this.unmuteUrls.clone();
                    }
                    case "video_close": {
                        return (String[])this.closeUrls.clone();
                    }
                    case "click_url": {
                        return (String[])this.clickUrls.clone();
                    }
                    case "video_click": {
                        return (String[])this.videoClickUrls.clone();
                    }
                }
                throw new IllegalArgumentException("Unknown TPAT Event " + event);
            }
            case 1: {
                if (event.startsWith("checkpoint")) {
                    String[] ret = new String[]{};
                    int percent = Integer.parseInt(event.split("\\.")[1]);
                    Checkpoint cpoint = this.checkpoints.get(percent / 25);
                    if (cpoint != null) {
                        ret = cpoint.getUrls();
                    }
                    return ret;
                }
                switch (event) {
                    case "video.close": {
                        return (String[])this.closeUrls.clone();
                    }
                    case "postroll.view": {
                        return (String[])this.postRollViewUrls.clone();
                    }
                    case "postroll.click": {
                        return (String[])this.postRollClickUrls.clone();
                    }
                    case "clickUrl": {
                        return (String[])this.clickUrls.clone();
                    }
                    case "video.mute": {
                        return (String[])this.muteUrls.clone();
                    }
                    case "video.unmute": {
                        return (String[])this.unmuteUrls.clone();
                    }
                    case "video_click": {
                        return (String[])this.videoClickUrls.clone();
                    }
                }
                throw new IllegalArgumentException("Unknown TPAT Event " + event);
            }
        }
        throw new IllegalStateException("Unknown Advertisement Type!");
    }

    @NonNull
    public String getId() {
        if (this.identifier == null) {
            return "";
        }
        return this.identifier;
    }

    public String getAdToken() {
        return this.adToken;
    }

    public String getAppID() {
        return this.appID;
    }

    String getUrl() {
        return this.videoUrl;
    }

    public String getCampaign() {
        return this.campaign;
    }

    String getTemplateId() {
        return this.templateId;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public int getShowCloseDelay(boolean incentivized) {
        if (incentivized) {
            return this.showCloseIncentivized * 1000;
        }
        return this.showCloseDelay * 1000;
    }

    public boolean getMoatEnabled() {
        return this.enableMoat;
    }

    public String getMoatVastExtra() {
        return this.moatExtraVast;
    }

    public long getExpireTime() {
        return this.expireTime * 1000L;
    }

    public JsonObject createMRAIDArgs() {
        if (this.templateSettings == null) {
            throw new IllegalArgumentException("Advertisement does not have MRAID Arguments!");
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(this.templateSettings);
        for (Map.Entry<String, Pair<String, String>> entry : this.cacheableAssets.entrySet()) {
            resultMap.put(entry.getKey(), (String)entry.getValue().first);
        }
        if (!this.mraidFiles.isEmpty()) {
            resultMap.putAll(this.mraidFiles);
        }
        if (!"true".equalsIgnoreCase((String)resultMap.get(START_MUTED))) {
            resultMap.put(START_MUTED, (this.getAdConfig().getSettings() & 1) != 0 ? "true" : "false");
        }
        JsonObject ret = new JsonObject();
        for (Map.Entry entry : resultMap.entrySet()) {
            ret.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return ret;
    }

    @Nullable
    public String getCTAURL(boolean tpat) {
        switch (this.adType) {
            case 0: {
                return tpat ? this.ctaUrl : this.ctaDestinationUrl;
            }
            case 1: {
                return this.ctaUrl;
            }
        }
        throw new IllegalArgumentException("Unknown AdType " + this.adType);
    }

    public boolean hasPostroll() {
        return !TextUtils.isEmpty((CharSequence)this.postrollBundleUrl);
    }

    public Map<String, String> getDownloadableUrls() {
        HashMap<String, String> ret = new HashMap<String, String>();
        switch (this.adType) {
            case 0: {
                ret.put(KEY_VIDEO, this.videoUrl);
                if (TextUtils.isEmpty((CharSequence)this.postrollBundleUrl)) break;
                ret.put(KEY_POSTROLL, this.postrollBundleUrl);
                break;
            }
            case 1: {
                ret.put(KEY_TEMPLATE, this.templateUrl);
                for (Map.Entry<String, Pair<String, String>> entry : this.cacheableAssets.entrySet()) {
                    String httpUrl = (String)entry.getValue().first;
                    if (!this.isValidUrl(httpUrl)) continue;
                    String fileName = URLUtil.guessFileName((String)httpUrl, null, null);
                    ret.put(fileName, httpUrl);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Advertisement created without adType!");
            }
        }
        return ret;
    }

    private boolean isValidUrl(String httpUrl) {
        return !TextUtils.isEmpty((CharSequence)httpUrl) && HttpUrl.parse((String)httpUrl) != null;
    }

    public void setMraidAssetDir(File dir) {
        for (Map.Entry<String, Pair<String, String>> entry : this.cacheableAssets.entrySet()) {
            String fileName;
            File file;
            String httpUrl = (String)entry.getValue().first;
            if (!this.isValidUrl(httpUrl) || !(file = new File(dir, fileName = URLUtil.guessFileName((String)httpUrl, null, null))).exists()) continue;
            this.mraidFiles.put(entry.getKey(), FILE_SCHEME + file.getPath());
        }
    }

    public void setState(@State int state) {
        this.state = state;
    }

    @State
    public int getState() {
        return this.state;
    }

    public String getAdMarketId() {
        return this.adMarketId;
    }

    public String getBidToken() {
        return this.bidToken;
    }

    public String toString() {
        return "Advertisement{adType=" + this.adType + ", identifier='" + this.identifier + '\'' + ", appID='" + this.appID + '\'' + ", expireTime=" + this.expireTime + ", checkpoints=" + this.checkpoints + ", muteUrls=" + Arrays.toString(this.muteUrls) + ", unmuteUrls=" + Arrays.toString(this.unmuteUrls) + ", closeUrls=" + Arrays.toString(this.closeUrls) + ", postRollClickUrls=" + Arrays.toString(this.postRollClickUrls) + ", postRollViewUrls=" + Arrays.toString(this.postRollViewUrls) + ", videoClickUrls=" + Arrays.toString(this.videoClickUrls) + ", clickUrls=" + Arrays.toString(this.clickUrls) + ", delay=" + this.delay + ", campaign='" + this.campaign + '\'' + ", showCloseDelay=" + this.showCloseDelay + ", showCloseIncentivized=" + this.showCloseIncentivized + ", countdown=" + this.countdown + ", videoUrl='" + this.videoUrl + '\'' + ", videoWidth=" + this.videoWidth + ", videoHeight=" + this.videoHeight + ", md5='" + this.md5 + '\'' + ", postrollBundleUrl='" + this.postrollBundleUrl + '\'' + ", ctaOverlayEnabled=" + this.ctaOverlayEnabled + ", ctaClickArea=" + this.ctaClickArea + ", ctaDestinationUrl='" + this.ctaDestinationUrl + '\'' + ", ctaUrl='" + this.ctaUrl + '\'' + ", adConfig=" + this.adConfig + ", retryCount=" + this.retryCount + ", adToken='" + this.adToken + '\'' + ", videoIdentifier='" + this.videoIdentifier + '\'' + ", templateUrl='" + this.templateUrl + '\'' + ", templateSettings=" + this.templateSettings + ", mraidFiles=" + this.mraidFiles + ", cacheableAssets=" + this.cacheableAssets + ", templateId='" + this.templateId + '\'' + ", templateType='" + this.templateType + '\'' + ", enableMoat=" + this.enableMoat + ", moatExtraVast='" + this.moatExtraVast + '\'' + ", requiresNonMarketInstall=" + this.requiresNonMarketInstall + ", adMarketId='" + this.adMarketId + '\'' + ", bidToken='" + this.bidToken + '\'' + ", state=" + this.state + '}';
    }

    public String getAdvertiserAppId() {
        String advertiserAppId = this.getAppID();
        String rawAppIdJson = this.getAppID();
        if (rawAppIdJson != null && rawAppIdJson.length() > 3) {
            try {
                JSONObject appIdJson = new JSONObject(rawAppIdJson.substring(3));
                advertiserAppId = appIdJson.isNull("app_id") ? null : appIdJson.optString("app_id", null);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"JsonException : ", (Throwable)e);
            }
        }
        return TextUtils.isEmpty((CharSequence)advertiserAppId) ? UNKNOWN : advertiserAppId;
    }

    public String getCampaignId() {
        String[] campaignArr;
        String campaignId = null;
        String campaign = this.getCampaign();
        if (!TextUtils.isEmpty((CharSequence)campaign) && (campaignArr = campaign.split("\\|")).length >= 1) {
            campaignId = campaignArr[0];
        }
        return TextUtils.isEmpty(campaignId) ? UNKNOWN : campaignId;
    }

    public String getCreativeId() {
        String[] campaignArr;
        String creativeId = null;
        String campaign = this.getCampaign();
        if (!TextUtils.isEmpty((CharSequence)campaign) && (campaignArr = campaign.split("\\|")).length >= 2) {
            creativeId = campaignArr[1];
        }
        return TextUtils.isEmpty(creativeId) ? UNKNOWN : creativeId;
    }

    public static class Checkpoint
    implements Comparable<Checkpoint> {
        @SerializedName(value="percentage")
        private byte percentage;
        @SerializedName(value="urls")
        private String[] urls;

        public Checkpoint(JsonObject json) throws IllegalArgumentException {
            if (!JsonUtil.hasNonNull((JsonElement)json, "checkpoint")) {
                throw new IllegalArgumentException("Checkpoint missing percentage!");
            }
            this.percentage = (byte)(json.get("checkpoint").getAsFloat() * 100.0f);
            if (JsonUtil.hasNonNull((JsonElement)json, "urls")) {
                JsonArray urlsArray = json.getAsJsonArray("urls");
                this.urls = new String[urlsArray.size()];
                for (int x = 0; x < urlsArray.size(); ++x) {
                    this.urls[x] = null == urlsArray.get(x) || "null".equalsIgnoreCase(urlsArray.get(x).toString()) ? "" : urlsArray.get(x).getAsString();
                }
            } else {
                throw new IllegalArgumentException("Checkpoint missing reporting URL!");
            }
        }

        public Checkpoint(JsonArray urlsArray, byte percentage) {
            if (urlsArray.size() == 0) {
                throw new IllegalArgumentException("Empty URLS!");
            }
            this.urls = new String[urlsArray.size()];
            for (int x = 0; x < urlsArray.size(); ++x) {
                this.urls[x] = urlsArray.get(x).getAsString();
            }
            this.percentage = percentage;
        }

        public String[] getUrls() {
            return (String[])this.urls.clone();
        }

        public byte getPercentage() {
            return this.percentage;
        }

        @Override
        public int compareTo(@NonNull Checkpoint o) {
            return Float.compare(this.percentage, o.percentage);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Checkpoint)) {
                return false;
            }
            Checkpoint wrap = (Checkpoint)obj;
            if (wrap.percentage != this.percentage) {
                return false;
            }
            if (wrap.urls.length != this.urls.length) {
                return false;
            }
            for (int x = 0; x < this.urls.length; ++x) {
                if (wrap.urls[x].equals(this.urls[x])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = this.percentage;
            result = 31 * result + this.urls.length;
            result = 31 * result + Arrays.hashCode(this.urls);
            return result;
        }
    }

    public static @interface State {
    }

    public static @interface CacheKey {
    }

    public static @interface Orientation {
    }

    public static @interface AdType {
    }
}

