/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.downloader;

import android.text.TextUtils;
import androidx.annotation.Nullable;

class RangeResponse {
    private static String TAG = RangeResponse.class.getName();
    @Nullable
    public final String dimension;
    public final long rangeStart;
    public final long rangeEnd;
    public final long total;

    public RangeResponse(String header) {
        String[] parts;
        long rangeEndParsed = -1L;
        long rangeStartParsed = -1L;
        long totalParsed = -1L;
        String dimensionParsed = null;
        if (!TextUtils.isEmpty((CharSequence)header) && (parts = header.trim().split("\\s+")).length >= 2) {
            String[] rangeSegments;
            if (parts.length > 0) {
                dimensionParsed = parts[0];
            }
            if (parts.length > 1 && !TextUtils.isEmpty((CharSequence)parts[1]) && (rangeSegments = parts[1].split("/")).length == 2) {
                String[] ranges;
                if (!(TextUtils.isEmpty((CharSequence)rangeSegments[0]) || (ranges = rangeSegments[0].split("-")).length != 2 || TextUtils.isEmpty((CharSequence)ranges[0]) || TextUtils.isEmpty((CharSequence)ranges[1]))) {
                    try {
                        rangeStartParsed = Long.parseLong(ranges[0]);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        rangeEndParsed = Long.parseLong(ranges[1]);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)rangeSegments[1])) {
                    try {
                        totalParsed = Long.parseLong(rangeSegments[1]);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        this.rangeStart = rangeStartParsed;
        this.rangeEnd = rangeEndParsed;
        this.total = totalParsed;
        this.dimension = dimensionParsed;
    }
}

