/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.downloader;

import androidx.annotation.NonNull;
import com.vungle.warren.downloader.CachePolicy;
import com.vungle.warren.persistence.CacheManager;
import com.vungle.warren.utility.FileUtility;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

public class LRUCachePolicy
implements CachePolicy<File> {
    static final String CACHE_POLICY_JOURNAL = "cache_policy_journal";
    private final CacheManager cacheManager;
    private final String dirName;
    private LinkedHashSet<File> files = new LinkedHashSet();

    public LRUCachePolicy(@NonNull CacheManager cacheManager, @NonNull String dirName) {
        this.cacheManager = cacheManager;
        this.dirName = dirName;
    }

    @Override
    public void put(@NonNull File obj, long score) {
        if (score > 0L) {
            this.files.remove(obj);
        }
        this.files.add(obj);
    }

    @Override
    public List<File> getOrderedCacheItems() {
        return new ArrayList<File>(this.files);
    }

    @Override
    public void remove(@NonNull File obj) {
        this.files.remove(obj);
    }

    @Override
    public void clean() {
        this.files.clear();
    }

    @Override
    public void save() {
        FileUtility.writeSerializable(this.getPolicyFile(), this.files);
    }

    private File getPolicyFile() {
        File homeDir = new File(this.cacheManager.getCache(), this.dirName);
        if (homeDir.exists() && !homeDir.isDirectory()) {
            homeDir.delete();
        }
        if (!homeDir.exists()) {
            homeDir.mkdirs();
        }
        return new File(homeDir, CACHE_POLICY_JOURNAL);
    }

    @Override
    public void load() {
        File policyFile = this.getPolicyFile();
        Serializable serializable = (Serializable)FileUtility.readSerializable(policyFile);
        if (serializable == null) {
            return;
        }
        if (serializable instanceof Collection) {
            this.files.addAll((Collection)((Object)serializable));
        } else {
            policyFile.delete();
        }
    }
}

