/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.downloader;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Pair;
import com.vungle.warren.downloader.AssetDownloadListener;
import com.vungle.warren.downloader.DownloadRequest;
import com.vungle.warren.downloader.DownloadRequestMediator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

@Keep
class DownloadRequestMediator {
    public final String url;
    public final String filePath;
    public final String metaPath;
    public final boolean isCacheable;
    public final String key;
    private AtomicInteger statusAtomic = new AtomicInteger(0);
    private Map<String, Pair<DownloadRequest, AssetDownloadListener>> children = new ConcurrentHashMap<String, Pair<DownloadRequest, AssetDownloadListener>>(1);
    private volatile ReentrantLock lock = new ReentrantLock();
    private AtomicBoolean connectedAtomic = new AtomicBoolean(true);

    DownloadRequestMediator(@NonNull DownloadRequest downloadRequest, @Nullable AssetDownloadListener downloadListener, @NonNull String filePath, @NonNull String metaPath, boolean isCacheable, String key) {
        this.url = downloadRequest.url;
        this.filePath = filePath;
        this.metaPath = metaPath;
        this.isCacheable = isCacheable;
        this.key = key;
        this.children.put(downloadRequest.id, (Pair<DownloadRequest, AssetDownloadListener>)new Pair((Object)downloadRequest, (Object)downloadListener));
    }

    synchronized void add(DownloadRequest downloadRequest, AssetDownloadListener downloadListener) {
        this.children.put(downloadRequest.id, (Pair<DownloadRequest, AssetDownloadListener>)new Pair((Object)downloadRequest, (Object)downloadListener));
    }

    synchronized Pair<DownloadRequest, AssetDownloadListener> remove(DownloadRequest downloadRequest) {
        return this.children.remove(downloadRequest.id);
    }

    synchronized List<Pair<DownloadRequest, AssetDownloadListener>> values() {
        return new ArrayList<Pair<DownloadRequest, AssetDownloadListener>>(this.children.values());
    }

    synchronized List<DownloadRequest> requests() {
        List<Pair<DownloadRequest, AssetDownloadListener>> pairs = this.values();
        ArrayList<DownloadRequest> requests = new ArrayList<DownloadRequest>();
        for (Pair<DownloadRequest, AssetDownloadListener> pair : pairs) {
            requests.add((DownloadRequest)pair.first);
        }
        return requests;
    }

    void lock() {
        this.lock.lock();
    }

    void unlock() {
        this.lock.unlock();
    }

    int getPriority() {
        int priority = 0;
        for (Pair<DownloadRequest, AssetDownloadListener> pair : this.values()) {
            if (pair.first == null) continue;
            priority = Math.max(priority, ((DownloadRequest)pair.first).priority);
        }
        return priority;
    }

    boolean isPausable() {
        for (Pair<DownloadRequest, AssetDownloadListener> pair : this.values()) {
            if (pair.first == null || !((DownloadRequest)pair.first).pauseOnConnectionLost) continue;
            return true;
        }
        return false;
    }

    @Status
    public int getStatus() {
        return this.statusAtomic.get();
    }

    boolean is(@Status int status) {
        return this.statusAtomic.get() == status;
    }

    void set(@Status int status) {
        if (this.statusAtomic.get() == 3) {
            return;
        }
        this.statusAtomic.set(status);
    }

    boolean isConnected() {
        return this.connectedAtomic.get();
    }

    void setConnected(boolean value) {
        this.connectedAtomic.set(value);
    }
}

