/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.downloader;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.vungle.warren.downloader.Downloader;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class DownloadRequest {
    public final int networkType;
    public final int priority;
    public final String url;
    public final String path;
    public final boolean pauseOnConnectionLost;
    final String id;
    public final String cookieString;
    private AtomicBoolean cancelled = new AtomicBoolean(false);

    public DownloadRequest(@NonNull String url, String path) {
        this(3, 1, url, path, false, null);
    }

    public DownloadRequest(@NonNull String url, String path, String cookieString) {
        this(3, 1, url, path, false, cookieString);
    }

    public DownloadRequest(@Downloader.NetworkType int networkType, @Priority int priority, @NonNull String url, @NonNull String path, boolean pauseOnConnectionLost, String cookieString) {
        if (TextUtils.isEmpty((CharSequence)path) || TextUtils.isEmpty((CharSequence)url)) {
            throw new IllegalArgumentException("Url or path is empty");
        }
        this.networkType = networkType;
        this.priority = priority;
        this.url = url;
        this.path = path;
        this.id = UUID.nameUUIDFromBytes((path + "_" + url).getBytes()).toString();
        this.pauseOnConnectionLost = pauseOnConnectionLost;
        this.cookieString = cookieString;
    }

    void cancel() {
        this.cancelled.set(true);
    }

    boolean isCancelled() {
        return this.cancelled.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadRequest that = (DownloadRequest)o;
        if (this.networkType != that.networkType) {
            return false;
        }
        if (this.priority != that.priority) {
            return false;
        }
        if (this.pauseOnConnectionLost != that.pauseOnConnectionLost) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.cookieString != null ? !this.cookieString.equals(that.cookieString) : that.cookieString != null) {
            return false;
        }
        return this.cancelled != null ? this.cancelled.equals(that.cancelled) : that.cancelled == null;
    }

    public int hashCode() {
        int result = this.networkType;
        result = 31 * result + this.priority;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.pauseOnConnectionLost ? 1 : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.cookieString != null ? this.cookieString.hashCode() : 0);
        result = 31 * result + (this.cancelled != null ? this.cancelled.hashCode() : 0);
        return result;
    }

    public static @interface Priority {
        public static final int LOW = 0;
        public static final int DEFAULT = 1;
        public static final int HIGH = 2;
    }
}

