/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.download;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.vungle.warren.download.ApkDownloader;
import com.vungle.warren.download.DefaultApkDownloader;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class ApkDownloadManager {
    public static final int DIRECT_DOWNLOAD_FLAG_NOT_SET = -1;
    public static final int DIRECT_DOWNLOAD_FLAG_DISABLED = 0;
    public static final int DIRECT_DOWNLOAD_FLAG_ENABLED = 1;
    private static final String TAG = "ApkDownloadManager";
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile ApkDownloadManager INSTANCE;
    private Context context;
    private int directDownloadStatus = -1;
    private ApkDownloader inAppApkDownloader;
    private DefaultApkDownloader defaultApkDownloader;
    private ServiceLoader<ApkDownloader> serviceLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApkDownloadManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ApkDownloadManager> clazz = ApkDownloadManager.class;
        synchronized (ApkDownloadManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ApkDownloadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void init(@NonNull Context ctx, int status) {
        this.context = ctx.getApplicationContext();
        this.directDownloadStatus = status;
        if (this.inAppApkDownloader == null) {
            this.inAppApkDownloader = this.findPlugin();
        }
        if (this.defaultApkDownloader == null) {
            this.defaultApkDownloader = new DefaultApkDownloader();
        }
    }

    public void download(String url, boolean requiresSideLoading) {
        if (TextUtils.isEmpty((CharSequence)url) || this.context == null) {
            Log.e((String)TAG, (String)"Invalid params found!");
            return;
        }
        if (this.inAppApkDownloader != null && this.inAppApkDownloader.canDownload(this.context, this.directDownloadStatus, requiresSideLoading)) {
            Log.d((String)TAG, (String)"Using InAppDownloader to download the apk.");
            this.inAppApkDownloader.download(this.context, url);
        } else if (this.defaultApkDownloader != null && this.defaultApkDownloader.canDownload(this.context, this.directDownloadStatus, requiresSideLoading)) {
            Log.d((String)TAG, (String)"Using default downloader.");
            this.defaultApkDownloader.download(this.context, url);
        } else {
            Log.e((String)TAG, (String)"Error occurred processing this URL!");
        }
    }

    private ApkDownloader findPlugin() {
        if (this.serviceLoader == null) {
            this.serviceLoader = ServiceLoader.load(ApkDownloader.class);
        }
        if (this.serviceLoader != null) {
            try {
                Iterator<ApkDownloader> mIterator = this.serviceLoader.iterator();
                if (mIterator.hasNext()) {
                    return mIterator.next();
                }
            }
            catch (ServiceConfigurationError error) {
                Log.d((String)TAG, (String)("find plugin failed:" + error.getMessage()));
            }
            Log.d((String)TAG, (String)"No Direct download plugin class found.");
        }
        return null;
    }
}

