/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.analytics;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.gson.JsonObject;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.analytics.AdAnalytics;
import java.net.MalformedURLException;
import java.util.ArrayList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class VungleAnalytics
implements AdAnalytics {
    private static final String TAG = VungleAnalytics.class.getSimpleName();
    private final VungleApiClient client;

    public VungleAnalytics(VungleApiClient client) {
        this.client = client;
    }

    @Override
    public String[] ping(@NonNull String[] urls) {
        if (urls.length == 0) {
            return urls;
        }
        ArrayList<String> failed = new ArrayList<String>();
        for (String url : urls) {
            if (TextUtils.isEmpty((CharSequence)url)) continue;
            try {
                if (this.client.pingTPAT(url)) continue;
                failed.add(url);
            }
            catch (VungleApiClient.ClearTextTrafficException e) {
                Log.e((String)TAG, (String)("Cleartext Network Traffic is Blocked : " + url));
            }
            catch (MalformedURLException e) {
                Log.e((String)TAG, (String)("Invalid Url : " + url));
            }
        }
        return failed.toArray(new String[0]);
    }

    @Override
    public void ri(JsonObject object) {
        if (object == null) {
            return;
        }
        this.client.ri(object).enqueue((Callback)new Callback<JsonObject>(){

            public void onResponse(@NonNull Call<JsonObject> call, Response<JsonObject> response) {
                Log.d((String)TAG, (String)"send RI success");
            }

            public void onFailure(Call<JsonObject> call, Throwable t) {
                Log.d((String)TAG, (String)"send RI Failure");
            }
        });
    }
}

