/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.analytics;

import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import android.widget.VideoView;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.moat.analytics.mobile.vng.MoatAdEvent;
import com.moat.analytics.mobile.vng.MoatAdEventType;
import com.moat.analytics.mobile.vng.ReactiveVideoTracker;
import com.vungle.warren.analytics.AnalyticsVideoTracker;
import com.vungle.warren.model.Advertisement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class MoatTracker
implements AnalyticsVideoTracker {
    private static final String TAG = MoatTracker.class.getSimpleName();
    public static final String VUNGLE_ID = "vunglenativevideo893259554489";
    private static final String UNKNOWN = "unknown";
    private VideoView videoView;
    private boolean isMoatEnabled;
    private boolean configured;
    private ReactiveVideoTracker tracker;
    private Map<String, String> adIds = new HashMap<String, String>();
    private Queue<Pair<Integer, MoatAdEventType>> moatQuartileTrackers;

    private MoatTracker(@NonNull VideoView videoView, boolean isMoatEnabled) {
        this.isMoatEnabled = isMoatEnabled;
        this.videoView = videoView;
    }

    public void configure(@NonNull String placementId, @NonNull Advertisement advertisement, @NonNull String appId, @NonNull ReactiveVideoTracker tracker) {
        this.tracker = tracker;
        boolean bl = this.isMoatEnabled = this.isMoatEnabled && !TextUtils.isEmpty((CharSequence)placementId) && advertisement != null && advertisement.getMoatEnabled();
        if (this.isMoatEnabled) {
            this.moatQuartileTrackers = new LinkedList<Pair<Integer, MoatAdEventType>>();
            this.moatQuartileTrackers.add((Pair<Integer, MoatAdEventType>)new Pair((Object)0, (Object)MoatAdEventType.AD_EVT_START));
            this.moatQuartileTrackers.add((Pair<Integer, MoatAdEventType>)new Pair((Object)25, (Object)MoatAdEventType.AD_EVT_FIRST_QUARTILE));
            this.moatQuartileTrackers.add((Pair<Integer, MoatAdEventType>)new Pair((Object)50, (Object)MoatAdEventType.AD_EVT_MID_POINT));
            this.moatQuartileTrackers.add((Pair<Integer, MoatAdEventType>)new Pair((Object)75, (Object)MoatAdEventType.AD_EVT_THIRD_QUARTILE));
            if (!advertisement.getMoatVastExtra().isEmpty()) {
                this.adIds.put("zMoatVASTIDs", advertisement.getMoatVastExtra());
            }
            this.adIds.put("level1", advertisement.getAdvertiserAppId());
            this.adIds.put("level2", advertisement.getCampaignId());
            this.adIds.put("level3", advertisement.getCreativeId());
            this.adIds.put("level4", TextUtils.isEmpty((CharSequence)placementId) ? UNKNOWN : placementId);
            if (!TextUtils.isEmpty((CharSequence)appId)) {
                this.adIds.put("slicer1", appId);
            }
            this.configured = true;
        }
        this.configured = this.configured && this.isMoatEnabled;
    }

    public static MoatTracker connect(@NonNull VideoView videoView, boolean isEnabled) {
        return new MoatTracker(videoView, isEnabled);
    }

    @Override
    public void onProgress(int progress) {
        if (this.configured) {
            if (progress >= 100) {
                this.tracker.dispatchEvent(new MoatAdEvent(MoatAdEventType.AD_EVT_COMPLETE, Integer.valueOf(this.videoView.getCurrentPosition())));
                this.tracker.stopTracking();
            } else if (!this.moatQuartileTrackers.isEmpty() && progress >= (Integer)this.moatQuartileTrackers.peek().first) {
                MoatAdEvent event = new MoatAdEvent((MoatAdEventType)this.moatQuartileTrackers.poll().second, Integer.valueOf(progress));
                this.tracker.dispatchEvent(event);
            }
        }
    }

    @Override
    public void start(int videoDuration) {
        if (this.configured) {
            Log.d((String)TAG, (String)"start");
            this.tracker.trackVideoAd(this.adIds, Integer.valueOf(videoDuration), (View)this.videoView);
        }
    }

    @Override
    public void stop() {
        if (this.configured) {
            int currentVideoPosition = this.videoView != null ? this.videoView.getCurrentPosition() : 0;
            Log.d((String)TAG, (String)("stopViewabilityTracker: " + currentVideoPosition));
            this.tracker.dispatchEvent(new MoatAdEvent(MoatAdEventType.AD_EVT_STOPPED, Integer.valueOf(currentVideoPosition)));
            this.tracker.stopTracking();
            Log.d((String)TAG, (String)"stopViewabilityTracker: Success !!");
        }
    }

    @VisibleForTesting
    Map<String, String> getAdIds() {
        return this.adIds;
    }
}

