/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.AdConfig;
import com.vungle.warren.Banners;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.ui.view.VungleNativeView;
import com.vungle.warren.utility.RefreshHandler;
import com.vungle.warren.utility.ViewUtility;
import com.vungle.warren.utility.WeakLoadAdCallback;
import com.vungle.warren.utility.WeakRunnable;

public class VungleBanner
extends RelativeLayout {
    private static final String TAG = VungleBanner.class.getSimpleName();
    private String placementId;
    private int calculatedPixelWidth;
    private int calculatedPixelHeight;
    private boolean destroyed;
    private boolean renderWhenAvailable;
    private boolean disableRenderManagement;
    @Nullable
    private VungleNativeView bannerAd;
    private AdConfig.AdSize adSize;
    private PlayAdCallback playAdCallback;
    private RefreshHandler refreshHandler;
    private boolean renderAdRequested;
    private Runnable refreshAdRunnable = new Runnable(){

        @Override
        public void run() {
            Log.d((String)TAG, (String)"Refresh Timeout Reached");
            VungleBanner.this.renderWhenAvailable = true;
            VungleBanner.this.loadAdInternal();
        }
    };
    private LoadAdCallback loadAdCallback = new LoadAdCallback(){

        @Override
        public void onAdLoad(String id) {
            Log.d((String)TAG, (String)("Ad Loaded : " + id));
            if (VungleBanner.this.renderWhenAvailable && VungleBanner.this.canRender()) {
                VungleBanner.this.renderWhenAvailable = false;
                VungleBanner.this.finishAdInternal(false);
                AdConfig config = new AdConfig();
                config.setAdSize(VungleBanner.this.adSize);
                VungleNativeView ad = Vungle.getNativeAdInternal(id, config, VungleBanner.this.playAdCallback);
                if (ad != null) {
                    VungleBanner.this.bannerAd = ad;
                    VungleBanner.this.renderAd();
                } else {
                    this.onError(VungleBanner.this.placementId, new VungleException(10));
                }
            }
        }

        @Override
        public void onError(String id, VungleException exception) {
            Log.d((String)TAG, (String)("Ad Load Error : " + id + " Message : " + exception.getLocalizedMessage()));
            if (VungleBanner.this.getVisibility() == 0 && VungleBanner.this.canRender()) {
                VungleBanner.this.refreshHandler.start();
            }
        }
    };

    protected VungleBanner(@NonNull Context context, String placementId, int adRefreshDuration, AdConfig.AdSize adSize, PlayAdCallback callback) {
        super(context);
        this.placementId = placementId;
        this.adSize = adSize;
        this.playAdCallback = callback;
        this.calculatedPixelHeight = ViewUtility.dpToPixels(context, adSize.getHeight());
        this.calculatedPixelWidth = ViewUtility.dpToPixels(context, adSize.getWidth());
        AdConfig config = new AdConfig();
        config.setAdSize(adSize);
        this.bannerAd = Vungle.getNativeAdInternal(placementId, config, this.playAdCallback);
        this.refreshHandler = new RefreshHandler(new WeakRunnable(this.refreshAdRunnable), adRefreshDuration * 1000);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        Log.d((String)TAG, (String)("Banner onWindowVisibilityChanged: " + visibility));
        this.setAdVisibility(visibility == 0);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Log.d((String)TAG, (String)"Banner onAttachedToWindow");
        if (this.disableRenderManagement) {
            return;
        }
        this.renderAd();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Log.d((String)TAG, (String)"Banner onDetachedFromWindow");
        if (this.disableRenderManagement) {
            return;
        }
        this.finishAdInternal(false);
    }

    public void renderAd() {
        this.renderAdRequested = true;
        if (this.getVisibility() != 0) {
            return;
        }
        if (this.bannerAd == null) {
            if (this.canRender()) {
                this.renderWhenAvailable = true;
                this.loadAdInternal();
            }
            return;
        }
        View view = this.bannerAd.renderNativeView();
        if (view.getParent() != this) {
            this.addView(view);
            Log.d((String)TAG, (String)"Add VungleNativeView to Parent");
        }
        Log.d((String)TAG, (String)("Rendering new ad for: " + this.placementId));
        ViewGroup.LayoutParams bannerLayoutParams = this.getLayoutParams();
        if (bannerLayoutParams != null) {
            bannerLayoutParams.height = this.calculatedPixelHeight;
            bannerLayoutParams.width = this.calculatedPixelWidth;
            this.requestLayout();
        }
        view.getLayoutParams().height = this.calculatedPixelHeight;
        view.getLayoutParams().width = this.calculatedPixelWidth;
        view.requestLayout();
        this.refreshHandler.start();
    }

    public void finishAd() {
        this.finishAdInternal(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishAdInternal(boolean isFinishedByApi) {
        VungleBanner vungleBanner = this;
        synchronized (vungleBanner) {
            this.refreshHandler.clean();
            if (this.bannerAd != null) {
                this.bannerAd.finishDisplayingAdInternal(isFinishedByApi);
                this.bannerAd = null;
                this.removeAllViews();
            }
        }
    }

    public void destroyAd() {
        this.finishAdInternal(true);
        this.destroyed = true;
        this.playAdCallback = null;
    }

    public void setAdVisibility(boolean visible) {
        if (visible && this.canRender()) {
            this.refreshHandler.start();
        } else {
            this.refreshHandler.pause();
        }
        if (this.bannerAd != null) {
            this.bannerAd.setAdVisibility(visible);
        }
    }

    private boolean canRender() {
        return !this.destroyed && (!this.disableRenderManagement || this.renderAdRequested);
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.setAdVisibility(visibility == 0);
    }

    protected void loadAdInternal() {
        Log.d((String)TAG, (String)"Loading Ad");
        Banners.loadBanner(this.placementId, this.adSize, new WeakLoadAdCallback(this.loadAdCallback));
    }

    public void disableLifeCycleManagement(boolean disable) {
        this.disableRenderManagement = disable;
    }
}

