/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.annotation.SuppressLint;
import android.app.Application;
import android.app.UiModeManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.provider.Settings;
import android.security.NetworkSecurityPolicy;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import android.webkit.URLUtil;
import android.webkit.WebSettings;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.PermissionChecker;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.moat.analytics.mobile.vng.MoatAnalytics;
import com.moat.analytics.mobile.vng.MoatOptions;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.model.JsonUtil;
import com.vungle.warren.network.VungleApi;
import com.vungle.warren.persistence.CacheManager;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.utility.ViewUtility;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class VungleApiClient {
    private final String TAG = "VungleApiClient";
    private Context context;
    private VungleApi api;
    private String newEndpoint;
    private String requestAdEndpoint;
    private String reportAdEndpoint;
    private String willPlayAdEndpoint;
    private String riEndpoint;
    private JsonObject deviceBody;
    private JsonObject appBody;
    private boolean willPlayAdEnabled;
    private int willPlayAdTimeout;
    private OkHttpClient client;
    private VungleApi timeoutApi;
    private VungleApi gzipApi;
    private boolean enableMoat;
    private CacheManager cacheManager;
    static final String MANUFACTURER_AMAZON = "Amazon";
    static String HEADER_UA = "Amazon".equals(Build.MANUFACTURER) ? "VungleAmazon/6.5.0" : "VungleDroid/6.5.0";
    private static String BASE_URL = "https://ads.api.vungle.com/";
    protected static WrapperFramework WRAPPER_FRAMEWORK_SELECTED;
    private JsonObject userBody;
    private Map<String, Long> retryAfterDataMap = new ConcurrentHashMap<String, Long>();
    private String userImei;
    private boolean shouldTransmitIMEI;
    private boolean defaultIdFallbackDisabled;
    private Repository repository;
    private String uaString = System.getProperty("http.agent");
    private static Set<Interceptor> networkInterceptors;
    private static Set<Interceptor> logInterceptors;

    VungleApiClient(@NonNull Context context, @NonNull CacheManager cacheManager, @NonNull Repository repository) {
        this.cacheManager = cacheManager;
        this.context = context.getApplicationContext();
        this.repository = repository;
        Interceptor responseInterceptor = new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                String retryAfterTimeStr;
                int responseCode;
                Response response;
                Request request = chain.request();
                String urlPath = request.url().encodedPath();
                Long retryExpireTime = (Long)VungleApiClient.this.retryAfterDataMap.get(urlPath);
                if (retryExpireTime != null) {
                    long currentTimeStamp = System.currentTimeMillis();
                    long newRetryAfter = TimeUnit.MILLISECONDS.toSeconds(retryExpireTime - currentTimeStamp);
                    if (newRetryAfter > 0L) {
                        return new Response.Builder().request(request).addHeader("Retry-After", String.valueOf(newRetryAfter)).code(500).protocol(Protocol.HTTP_1_1).message("Server is busy").body(ResponseBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)"{\"Error\":\"Retry-After\"}")).build();
                    }
                    VungleApiClient.this.retryAfterDataMap.remove(urlPath);
                }
                if (!((response = chain.proceed(request)) == null || (responseCode = response.code()) != 429 && responseCode != 500 && responseCode != 502 && responseCode != 503 || TextUtils.isEmpty((CharSequence)(retryAfterTimeStr = response.headers().get("Retry-After"))))) {
                    try {
                        long retryAfterTimeValue = Long.parseLong(retryAfterTimeStr);
                        if (retryAfterTimeValue > 0L) {
                            VungleApiClient.this.retryAfterDataMap.put(urlPath, retryAfterTimeValue * 1000L + System.currentTimeMillis());
                        }
                    }
                    catch (NumberFormatException e) {
                        Log.d((String)"VungleApiClient", (String)"Retry-After value is not an valid value");
                    }
                }
                return response;
            }
        };
        OkHttpClient.Builder builder = new OkHttpClient.Builder().addInterceptor(responseInterceptor);
        this.client = builder.build();
        OkHttpClient gzipClient = builder.addInterceptor((Interceptor)new GzipRequestInterceptor()).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.client).build();
        this.api = (VungleApi)retrofit.create(VungleApi.class);
        this.gzipApi = (VungleApi)retrofit.newBuilder().client(gzipClient).build().create(VungleApi.class);
    }

    public void init(String appId) {
        this.init(this.context, appId);
    }

    public void updateIMEI(String imei, boolean shouldTransmit) {
        this.userImei = imei;
        this.shouldTransmitIMEI = shouldTransmit;
    }

    public void setDefaultIdFallbackDisabled(boolean disabled) {
        this.defaultIdFallbackDisabled = disabled;
    }

    private synchronized void init(final Context context, String appID) {
        this.shouldTransmitIMEI = false;
        JsonObject app = new JsonObject();
        app.addProperty("id", appID);
        app.addProperty("bundle", context.getPackageName());
        String versionName = null;
        try {
            versionName = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        app.addProperty("ver", versionName != null ? versionName : "1.0");
        JsonObject device = new JsonObject();
        device.addProperty("make", Build.MANUFACTURER);
        device.addProperty("model", Build.MODEL);
        device.addProperty("osv", Build.VERSION.RELEASE);
        device.addProperty("carrier", ((TelephonyManager)context.getSystemService("phone")).getNetworkOperatorName());
        device.addProperty("os", MANUFACTURER_AMAZON.equals(Build.MANUFACTURER) ? "amazon" : "android");
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(dm);
        device.addProperty("w", (Number)dm.widthPixels);
        device.addProperty("h", (Number)dm.heightPixels);
        JsonObject ext = new JsonObject();
        JsonObject vungle = new JsonObject();
        ext.add("vungle", (JsonElement)vungle);
        device.add("ext", (JsonElement)ext);
        try {
            if (Build.VERSION.SDK_INT >= 17) {
                this.uaString = this.getUserAgentFromCookie();
                this.initUserAgentLazy();
            } else if (Looper.getMainLooper() == Looper.myLooper()) {
                this.uaString = ViewUtility.getWebView(context.getApplicationContext()).getSettings().getUserAgentString();
            } else {
                final CountDownLatch latch = new CountDownLatch(1);
                Handler handler = new Handler(Looper.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            VungleApiClient.this.uaString = ViewUtility.getWebView(context.getApplicationContext()).getSettings().getUserAgentString();
                        }
                        catch (InstantiationException ex) {
                            Log.e((String)"VungleApiClient", (String)("Cannot Get UserAgent. Setting Default Device UserAgent." + ex.getLocalizedMessage()));
                        }
                        latch.countDown();
                    }
                });
                if (!latch.await(2L, TimeUnit.SECONDS)) {
                    Log.e((String)"VungleApiClient", (String)"Unable to get User Agent String in specified time");
                }
            }
        }
        catch (Exception ex) {
            Log.e((String)"VungleApiClient", (String)("Cannot Get UserAgent. Setting Default Device UserAgent." + ex.getLocalizedMessage()));
        }
        device.addProperty("ua", this.uaString);
        this.deviceBody = device;
        this.appBody = app;
    }

    @RequiresApi(api=17)
    private void initUserAgentLazy() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    VungleApiClient.this.uaString = WebSettings.getDefaultUserAgent((Context)VungleApiClient.this.context);
                    VungleApiClient.this.deviceBody.addProperty("ua", VungleApiClient.this.uaString);
                    VungleApiClient.this.addUserAgentInCookie(VungleApiClient.this.uaString);
                }
                catch (Exception ex) {
                    Log.e((String)"VungleApiClient", (String)("Cannot Get UserAgent. Setting Default Device UserAgent." + ex.getLocalizedMessage()));
                }
            }
        }).start();
    }

    public retrofit2.Response<JsonObject> config() throws VungleException, IOException {
        JsonObject body = new JsonObject();
        body.add("device", (JsonElement)this.getDeviceBody());
        body.add("app", (JsonElement)this.appBody);
        body.add("user", (JsonElement)this.getUserBody());
        retrofit2.Response response = this.api.config(HEADER_UA, body).execute();
        if (!response.isSuccessful()) {
            return response;
        }
        JsonObject jsonObject = (JsonObject)response.body();
        Log.d((String)"VungleApiClient", (String)("Config Response: " + jsonObject));
        if (JsonUtil.hasNonNull((JsonElement)jsonObject, "sleep")) {
            String errorMessage = JsonUtil.hasNonNull((JsonElement)jsonObject, "info") ? jsonObject.get("info").getAsString() : "";
            Log.e((String)"VungleApiClient", (String)("Error Initializing Vungle. Please try again. " + errorMessage));
            throw new VungleException(3);
        }
        if (!JsonUtil.hasNonNull((JsonElement)jsonObject, "endpoints")) {
            Log.e((String)"VungleApiClient", (String)"Error Initializing Vungle. Please try again. ");
            throw new VungleException(3);
        }
        JsonObject endpoints = jsonObject.getAsJsonObject("endpoints");
        HttpUrl newUrl = HttpUrl.parse((String)endpoints.get("new").getAsString());
        HttpUrl adsUrl = HttpUrl.parse((String)endpoints.get("ads").getAsString());
        HttpUrl willPlayAdUrl = HttpUrl.parse((String)endpoints.get("will_play_ad").getAsString());
        HttpUrl reportAdUrl = HttpUrl.parse((String)endpoints.get("report_ad").getAsString());
        HttpUrl reportIncentivized = HttpUrl.parse((String)endpoints.get("ri").getAsString());
        if (newUrl == null || adsUrl == null || willPlayAdUrl == null || reportAdUrl == null || reportIncentivized == null) {
            Log.e((String)"VungleApiClient", (String)"Error Initializing Vungle. Please try again. ");
            throw new VungleException(3);
        }
        this.newEndpoint = newUrl.toString();
        this.requestAdEndpoint = adsUrl.toString();
        this.willPlayAdEndpoint = willPlayAdUrl.toString();
        this.reportAdEndpoint = reportAdUrl.toString();
        this.riEndpoint = reportIncentivized.toString();
        JsonObject willPlayAd = jsonObject.getAsJsonObject("will_play_ad");
        this.willPlayAdTimeout = willPlayAd.get("request_timeout").getAsInt();
        this.willPlayAdEnabled = willPlayAd.get("enabled").getAsBoolean();
        JsonObject moatViewability = jsonObject.getAsJsonObject("viewability");
        this.enableMoat = moatViewability.get("moat").getAsBoolean();
        if (this.willPlayAdEnabled) {
            Log.v((String)"VungleApiClient", (String)"willPlayAd is enabled, generating a timeout client.");
            OkHttpClient timeoutClient = this.client.newBuilder().readTimeout((long)this.willPlayAdTimeout, TimeUnit.MILLISECONDS).build();
            Retrofit timeoutRetro = new Retrofit.Builder().client(timeoutClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).baseUrl("https://api.vungle.com/").build();
            this.timeoutApi = (VungleApi)timeoutRetro.create(VungleApi.class);
        }
        if (this.getMoatEnabled()) {
            MoatOptions options = new MoatOptions();
            options.disableAdIdCollection = true;
            options.disableLocationServices = true;
            options.loggingEnabled = true;
            MoatAnalytics.getInstance().start(options, (Application)this.context.getApplicationContext());
        }
        return response;
    }

    public Call<JsonObject> reportNew() throws IllegalStateException {
        if (this.newEndpoint == null) {
            throw new IllegalStateException("API Client not configured yet! Must call /config first.");
        }
        HashMap<String, String> query = new HashMap<String, String>(2);
        JsonElement idElement = this.appBody.get("id");
        JsonElement ifaElement = this.deviceBody.get("ifa");
        query.put("app_id", idElement != null ? idElement.getAsString() : "");
        query.put("ifa", ifaElement != null ? ifaElement.getAsString() : "");
        return this.api.reportNew(HEADER_UA, this.newEndpoint, query);
    }

    public Call<JsonObject> requestAd(String placement, String adSize, boolean isHeaderBiddingEnable, @Nullable JsonObject vision) throws IllegalStateException {
        if (this.requestAdEndpoint == null) {
            throw new IllegalStateException("API Client not configured yet! Must call /config first.");
        }
        JsonObject body = new JsonObject();
        body.add("device", (JsonElement)this.getDeviceBody());
        body.add("app", (JsonElement)this.appBody);
        JsonObject userBody = this.getUserBody();
        if (vision != null) {
            userBody.add("vision", (JsonElement)vision);
        }
        body.add("user", (JsonElement)userBody);
        JsonObject request = new JsonObject();
        JsonArray placementsArray = new JsonArray();
        placementsArray.add(placement);
        request.add("placements", (JsonElement)placementsArray);
        request.addProperty("header_bidding", Boolean.valueOf(isHeaderBiddingEnable));
        if (!TextUtils.isEmpty((CharSequence)adSize)) {
            request.addProperty("ad_size", adSize);
        }
        body.add("request", (JsonElement)request);
        return this.gzipApi.ads(HEADER_UA, this.requestAdEndpoint, body);
    }

    Call<JsonObject> willPlayAd(String placementID, boolean autoCached, String adToken) {
        JsonObject body = new JsonObject();
        body.add("device", (JsonElement)this.getDeviceBody());
        body.add("app", (JsonElement)this.appBody);
        body.add("user", (JsonElement)this.getUserBody());
        JsonObject request = new JsonObject();
        JsonObject placement = new JsonObject();
        placement.addProperty("reference_id", placementID);
        placement.addProperty("is_auto_cached", Boolean.valueOf(autoCached));
        request.add("placement", (JsonElement)placement);
        request.addProperty("ad_token", adToken);
        body.add("request", (JsonElement)request);
        return this.timeoutApi.willPlayAd(HEADER_UA, this.willPlayAdEndpoint, body);
    }

    boolean canCallWillPlayAd() {
        return this.willPlayAdEnabled && !TextUtils.isEmpty((CharSequence)this.willPlayAdEndpoint);
    }

    public Call<JsonObject> reportAd(JsonObject request) {
        if (this.reportAdEndpoint == null) {
            throw new IllegalStateException("API Client not configured yet! Must call /config first.");
        }
        JsonObject body = new JsonObject();
        body.add("device", (JsonElement)this.getDeviceBody());
        body.add("app", (JsonElement)this.appBody);
        body.add("request", (JsonElement)request);
        body.add("user", (JsonElement)this.getUserBody());
        return this.gzipApi.reportAd(HEADER_UA, this.reportAdEndpoint, body);
    }

    public Call<JsonObject> ri(JsonObject request) {
        if (this.riEndpoint == null) {
            throw new IllegalStateException("API Client not configured yet! Must call /config first.");
        }
        JsonObject body = new JsonObject();
        body.add("device", (JsonElement)this.getDeviceBody());
        body.add("app", (JsonElement)this.appBody);
        body.add("request", (JsonElement)request);
        return this.api.ri(HEADER_UA, this.riEndpoint, body);
    }

    public boolean pingTPAT(String url) throws ClearTextTrafficException, MalformedURLException {
        if (!TextUtils.isEmpty((CharSequence)url) && HttpUrl.parse((String)url) != null) {
            String host;
            try {
                host = new URL(url).getHost();
            }
            catch (MalformedURLException e) {
                throw new MalformedURLException("Invalid URL : " + url);
            }
            boolean clearTextTrafficPermitted = Build.VERSION.SDK_INT >= 24 ? NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted(host) : (Build.VERSION.SDK_INT >= 23 ? NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted() : true);
            if (!clearTextTrafficPermitted && URLUtil.isHttpUrl((String)url)) {
                throw new ClearTextTrafficException("Clear Text Traffic is blocked");
            }
            String finalUrl = !TextUtils.isEmpty((CharSequence)this.userImei) && this.shouldTransmitIMEI ? url.replace("%imei%", this.userImei) : url;
            try {
                this.api.pingTPAT(this.uaString, finalUrl).execute();
            }
            catch (IOException e) {
                return false;
            }
        }
        throw new MalformedURLException("Invalid URL : " + url);
        return true;
    }

    @SuppressLint(value={"HardwareIds"})
    private JsonObject getDeviceBody() throws IllegalStateException {
        boolean isTV;
        String batteryState;
        int status;
        boolean limitAdTracking;
        String advertId;
        JsonObject android;
        block52: {
            android = new JsonObject();
            advertId = null;
            limitAdTracking = true;
            try {
                AdvertisingIdClient.Info idInfo = null;
                if (MANUFACTURER_AMAZON.equals(Build.MANUFACTURER)) {
                    try {
                        ContentResolver cr = this.context.getContentResolver();
                        limitAdTracking = Settings.Secure.getInt((ContentResolver)cr, (String)"limit_ad_tracking") == 1;
                        advertId = Settings.Secure.getString((ContentResolver)cr, (String)"advertising_id");
                    }
                    catch (Settings.SettingNotFoundException ex) {
                        Log.w((String)"VungleApiClient", (String)"Error getting Amazon advertising info", (Throwable)ex);
                    }
                    break block52;
                }
                try {
                    idInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.context);
                    if (idInfo != null) {
                        advertId = idInfo.getId();
                        limitAdTracking = idInfo.isLimitAdTrackingEnabled();
                        this.deviceBody.addProperty("ifa", advertId);
                    }
                }
                catch (NoClassDefFoundError ex) {
                    Log.e((String)"VungleApiClient", (String)("Play services Not available: " + ex.getLocalizedMessage()));
                    ContentResolver cr = this.context.getContentResolver();
                    advertId = Settings.Secure.getString((ContentResolver)cr, (String)"advertising_id");
                }
            }
            catch (Exception ex) {
                Log.e((String)"VungleApiClient", (String)"Cannot load Advertising ID");
            }
        }
        if (advertId != null) {
            android.addProperty(MANUFACTURER_AMAZON.equals(Build.MANUFACTURER) ? "amazon_advertising_id" : "gaid", advertId);
            this.deviceBody.addProperty("ifa", advertId);
        } else {
            String androidID = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
            this.deviceBody.addProperty("ifa", this.defaultIdFallbackDisabled ? "" : (!TextUtils.isEmpty((CharSequence)androidID) ? androidID : ""));
            if (!TextUtils.isEmpty((CharSequence)androidID) && !this.defaultIdFallbackDisabled) {
                android.addProperty("android_id", androidID);
            }
        }
        this.deviceBody.addProperty("lmt", (Number)(limitAdTracking ? 1 : 0));
        boolean isGooglePlayServicesAvailable = false;
        PackageManager packageManager = this.context.getPackageManager();
        if (packageManager != null) {
            try {
                packageManager.getPackageInfo("com.google.android.gms", 0);
                isGooglePlayServicesAvailable = true;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundEx) {
                Log.d((String)"VungleApiClient", (String)"Google Play Svc not found");
            }
        }
        android.addProperty("is_google_play_services_available", Boolean.valueOf(isGooglePlayServicesAvailable));
        Intent batteryStatus = this.context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        int level = batteryStatus.getIntExtra("level", -1);
        int scale = batteryStatus.getIntExtra("scale", -1);
        if (level > 0 && scale > 0) {
            android.addProperty("battery_level", (Number)Float.valueOf((float)level / (float)scale));
        }
        if ((status = batteryStatus.getIntExtra("status", -1)) == -1) {
            batteryState = "UNKNOWN";
        } else if (status == 2 || status == 5) {
            switch (batteryStatus.getIntExtra("plugged", -1)) {
                case 2: {
                    batteryState = "BATTERY_PLUGGED_USB";
                    break;
                }
                case 1: {
                    batteryState = "BATTERY_PLUGGED_AC";
                    break;
                }
                case 4: {
                    batteryState = "BATTERY_PLUGGED_WIRELESS";
                    break;
                }
                default: {
                    batteryState = "BATTERY_PLUGGED_OTHERS";
                    break;
                }
            }
        } else {
            batteryState = "NOT_CHARGING";
        }
        android.addProperty("battery_state", batteryState);
        if (Build.VERSION.SDK_INT >= 21) {
            PowerManager powerManager = (PowerManager)this.context.getSystemService("power");
            android.addProperty("battery_saver_enabled", (Number)(powerManager != null && powerManager.isPowerSaveMode() ? 1 : 0));
        }
        if (PermissionChecker.checkCallingOrSelfPermission((Context)this.context, (String)"android.permission.ACCESS_NETWORK_STATE") == 0) {
            NetworkInfo info;
            String connectionType = "NONE";
            String connectionTypeDetail = "NONE";
            ConnectivityManager cm = (ConnectivityManager)this.context.getSystemService("connectivity");
            if (cm != null && (info = cm.getActiveNetworkInfo()) != null) {
                switch (info.getType()) {
                    case 7: {
                        connectionType = "BLUETOOTH";
                        connectionTypeDetail = "BLUETOOTH";
                        break;
                    }
                    case 9: {
                        connectionType = "ETHERNET";
                        connectionTypeDetail = "ETHERNET";
                        break;
                    }
                    case 0: {
                        connectionType = "MOBILE";
                        connectionTypeDetail = this.getConnectionTypeDetail(info.getSubtype());
                        break;
                    }
                    case 1: 
                    case 6: {
                        connectionType = "WIFI";
                        connectionTypeDetail = "WIFI";
                        break;
                    }
                    default: {
                        connectionType = "UNKNOWN";
                        connectionTypeDetail = "UNKNOWN";
                    }
                }
            }
            android.addProperty("connection_type", connectionType);
            android.addProperty("connection_type_detail", connectionTypeDetail);
            if (Build.VERSION.SDK_INT >= 24) {
                if (cm.isActiveNetworkMetered()) {
                    String dataSaverStatus;
                    switch (cm.getRestrictBackgroundStatus()) {
                        case 3: {
                            dataSaverStatus = "ENABLED";
                            break;
                        }
                        case 2: {
                            dataSaverStatus = "WHITELISTED";
                            break;
                        }
                        case 1: {
                            dataSaverStatus = "DISABLED";
                            break;
                        }
                        default: {
                            dataSaverStatus = "UNKNOWN";
                        }
                    }
                    android.addProperty("data_saver_status", dataSaverStatus);
                    android.addProperty("network_metered", (Number)1);
                } else {
                    android.addProperty("data_saver_status", "NOT_APPLICABLE");
                    android.addProperty("network_metered", (Number)0);
                }
            }
        }
        android.addProperty("locale", Locale.getDefault().toString());
        android.addProperty("language", Locale.getDefault().getLanguage());
        android.addProperty("time_zone", TimeZone.getDefault().getID());
        AudioManager audio = (AudioManager)this.context.getSystemService("audio");
        if (audio != null) {
            int max = audio.getStreamMaxVolume(3);
            int current = audio.getStreamVolume(3);
            float vol = (float)current / (float)max;
            android.addProperty("volume_level", (Number)Float.valueOf(vol));
            android.addProperty("sound_enabled", (Number)(current > 0 ? 1 : 0));
        }
        File cacheDirectory = this.cacheManager.getCache();
        String cachePath = cacheDirectory.getPath();
        if (cacheDirectory.exists() && cacheDirectory.isDirectory()) {
            android.addProperty("storage_bytes_available", (Number)this.cacheManager.getBytesAvailable());
        }
        if (MANUFACTURER_AMAZON.equals(Build.MANUFACTURER)) {
            String AMAZON_FEATURE_FIRE_TV = "amazon.hardware.fire_tv";
            isTV = this.context.getApplicationContext().getPackageManager().hasSystemFeature("amazon.hardware.fire_tv");
        } else if (Build.VERSION.SDK_INT >= 23) {
            UiModeManager uiModeManager = (UiModeManager)this.context.getSystemService("uimode");
            isTV = uiModeManager.getCurrentModeType() == 4;
        } else {
            String FEATURE_ANDROID_TV = "com.google.android.tv";
            String FEATURE_HW_TOUCHSCREEN = "android.hardware.touchscreen";
            isTV = this.context.getApplicationContext().getPackageManager().hasSystemFeature("com.google.android.tv") || !this.context.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.touchscreen");
        }
        android.addProperty("is_tv", Boolean.valueOf(isTV));
        android.addProperty("os_api_level", (Number)Build.VERSION.SDK_INT);
        boolean canInstallNonMarket = false;
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                if (0 == this.context.checkCallingOrSelfPermission("android.permission.REQUEST_INSTALL_PACKAGES")) {
                    canInstallNonMarket = this.context.getApplicationContext().getPackageManager().canRequestPackageInstalls();
                }
            } else {
                canInstallNonMarket = Settings.Secure.getInt((ContentResolver)this.context.getContentResolver(), (String)"install_non_market_apps") == 1;
            }
        }
        catch (Settings.SettingNotFoundException e) {
            Log.e((String)"VungleApiClient", (String)"isInstallNonMarketAppsEnabled Settings not found", (Throwable)e);
        }
        android.addProperty("is_sideload_enabled", Boolean.valueOf(canInstallNonMarket));
        boolean isSDPresent = Environment.getExternalStorageState().equals("mounted");
        android.addProperty("sd_card_available", (Number)(isSDPresent ? 1 : 0));
        android.addProperty("os_name", Build.FINGERPRINT);
        android.addProperty("vduid", "");
        this.deviceBody.getAsJsonObject("ext").getAsJsonObject("vungle").add(MANUFACTURER_AMAZON.equals(Build.MANUFACTURER) ? "amazon" : "android", (JsonElement)android);
        return this.deviceBody;
    }

    private String getConnectionTypeDetail(int type) {
        switch (type) {
            case 7: {
                return "1xRTT";
            }
            case 4: {
                return "CDMA";
            }
            case 2: {
                return "EDGE";
            }
            case 14: {
                return "EHPRD";
            }
            case 5: {
                return "EVDO_0";
            }
            case 6: {
                return "EVDO_A";
            }
            case 12: {
                return "EVDO_B";
            }
            case 1: {
                return "GPRS";
            }
            case 8: {
                return "HSDPA";
            }
            case 10: {
                return "HSPA";
            }
            case 15: {
                return "HSPAP";
            }
            case 9: {
                return "HSUPA";
            }
            case 11: {
                return "IDEN";
            }
            case 13: {
                return "LTE";
            }
            case 3: {
                return "UMTS";
            }
            case 16: {
                return "GSM";
            }
            case 18: {
                return "IWLAN";
            }
            case 17: {
                return "TD_SCDMA";
            }
        }
        return "UNKNOWN";
    }

    private JsonObject getUserBody() {
        String messageVersion;
        long timestamp;
        String source;
        String status;
        JsonObject userBody = new JsonObject();
        Cookie consentCookie = this.repository.load("consentIsImportantToVungle", Cookie.class).get();
        if (consentCookie != null) {
            status = consentCookie.getString("consent_status");
            source = consentCookie.getString("consent_source");
            timestamp = consentCookie.getLong("timestamp");
            messageVersion = consentCookie.getString("consent_message_version");
        } else {
            status = "unknown";
            source = "no_interaction";
            timestamp = 0L;
            messageVersion = "";
        }
        JsonObject gdpr = new JsonObject();
        gdpr.addProperty("consent_status", status);
        gdpr.addProperty("consent_source", source);
        gdpr.addProperty("consent_timestamp", (Number)timestamp);
        gdpr.addProperty("consent_message_version", TextUtils.isEmpty((CharSequence)messageVersion) ? "" : messageVersion);
        userBody.add("gdpr", (JsonElement)gdpr);
        return userBody;
    }

    public boolean getMoatEnabled() {
        return this.enableMoat && Build.VERSION.SDK_INT >= 16;
    }

    private String getUserAgentFromCookie() {
        String tempUserAgent;
        Cookie cookie = this.repository.load("userAgent", Cookie.class).get();
        if (cookie == null) {
            tempUserAgent = System.getProperty("http.agent");
        } else {
            tempUserAgent = cookie.getString("userAgent");
            if (TextUtils.isEmpty((CharSequence)tempUserAgent)) {
                tempUserAgent = System.getProperty("http.agent");
            }
        }
        return tempUserAgent;
    }

    private void addUserAgentInCookie(String userAgent) throws DatabaseHelper.DBException {
        Cookie cookie = new Cookie("userAgent");
        cookie.putValue("userAgent", userAgent);
        this.repository.save(cookie);
    }

    public long getRetryAfterHeaderValue(retrofit2.Response<JsonObject> response) {
        String header = response.headers().get("Retry-After");
        try {
            return Long.parseLong(header) * 1000L;
        }
        catch (NumberFormatException ex) {
            return 0L;
        }
    }

    @VisibleForTesting
    void overrideApi(VungleApi api) {
        this.api = api;
    }

    static {
        networkInterceptors = new HashSet<Interceptor>();
        logInterceptors = new HashSet<Interceptor>();
    }

    public static class ClearTextTrafficException
    extends IOException {
        ClearTextTrafficException(String message) {
            super(message);
        }
    }

    @Keep
    public static enum WrapperFramework {
        admob,
        air,
        cocos2dx,
        corona,
        dfp,
        heyzap,
        marmalade,
        mopub,
        unity,
        fyber,
        ironsource,
        upsight,
        appodeal,
        aerserv,
        adtoapp,
        tapdaq,
        vunglehbs,
        none;

    }

    static class GzipRequestInterceptor
    implements Interceptor {
        private static final String CONTENT_ENCODING = "Content-Encoding";
        private static final String GZIP = "gzip";

        GzipRequestInterceptor() {
        }

        @NonNull
        public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
            Request originalRequest = chain.request();
            if (originalRequest.body() == null || originalRequest.header(CONTENT_ENCODING) != null) {
                return chain.proceed(originalRequest);
            }
            Request compressedRequest = originalRequest.newBuilder().header(CONTENT_ENCODING, GZIP).method(originalRequest.method(), this.gzip(originalRequest.body())).build();
            return chain.proceed(compressedRequest);
        }

        private RequestBody gzip(final RequestBody requestBody) throws IOException {
            final Buffer output = new Buffer();
            BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)output));
            requestBody.writeTo(gzipSink);
            gzipSink.close();
            return new RequestBody(){

                public MediaType contentType() {
                    return requestBody.contentType();
                }

                public long contentLength() {
                    return output.size();
                }

                public void writeTo(@NonNull BufferedSink sink) throws IOException {
                    sink.write(output.snapshot());
                }
            };
        }
    }
}

