/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vungle.warren.AdConfig;
import com.vungle.warren.AdLoader;
import com.vungle.warren.CleverCacheSettings;
import com.vungle.warren.HeaderBiddingCallback;
import com.vungle.warren.HeaderBiddingCallbackWrapper;
import com.vungle.warren.InitCallback;
import com.vungle.warren.InitCallbackWrapper;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.LoadAdCallbackWrapper;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.PlayAdCallbackWrapper;
import com.vungle.warren.PresentationFactory;
import com.vungle.warren.RuntimeValues;
import com.vungle.warren.ServiceLocator;
import com.vungle.warren.VisionController;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.VungleNativeAd;
import com.vungle.warren.VungleSettings;
import com.vungle.warren.download.ApkDownloadManager;
import com.vungle.warren.downloader.DownloadRequest;
import com.vungle.warren.downloader.Downloader;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.model.JsonUtil;
import com.vungle.warren.model.Placement;
import com.vungle.warren.persistence.CacheManager;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.tasks.CleanupJob;
import com.vungle.warren.tasks.JobRunner;
import com.vungle.warren.tasks.ReconfigJob;
import com.vungle.warren.tasks.SendReportsJob;
import com.vungle.warren.ui.VungleActivity;
import com.vungle.warren.ui.VungleFlexViewActivity;
import com.vungle.warren.ui.contract.AdContract;
import com.vungle.warren.ui.view.VungleNativeView;
import com.vungle.warren.utility.Executors;
import com.vungle.warren.utility.SDKExecutors;
import com.vungle.warren.vision.VisionConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.HttpException;
import retrofit2.Response;

@Keep
public class Vungle {
    private static final String TAG = Vungle.class.getCanonicalName();
    private static final String COM_VUNGLE_SDK = "com.vungle.sdk";
    static final Vungle _instance = new Vungle();
    private volatile Consent consent;
    private volatile String consentVersion;
    private Map<String, Boolean> playOperations = new ConcurrentHashMap<String, Boolean>();
    private volatile String appID;
    private Context context;
    private static volatile boolean isInitialized;
    private static AtomicBoolean isInitializing;
    private static AtomicBoolean isDepInit;
    private volatile boolean shouldTransmitIMEI;
    private volatile String userIMEI;
    private Gson gson = new GsonBuilder().create();
    private static CacheManager.Listener cacheListener;

    private Vungle() {
    }

    static Context getAppContext() {
        return Vungle._instance.context;
    }

    @Deprecated
    public static void init(@NonNull Collection<String> placements, @NonNull String appId, @NonNull Context context, @NonNull InitCallback callback) throws IllegalArgumentException {
        Vungle.init(appId, context, callback, new VungleSettings.Builder().build());
    }

    public static void init(@NonNull String appId, @NonNull Context context, @NonNull InitCallback callback) throws IllegalArgumentException {
        Vungle.init(appId, context, callback, new VungleSettings.Builder().build());
    }

    public static void init(final @NonNull String appId, final @NonNull Context context, @NonNull InitCallback callback, @NonNull VungleSettings settings) throws IllegalArgumentException {
        String VUNGLE_VERSION_STRING = "!SDK-VERSION-STRING!:com.vungle:publisher-sdk-android:6.5.0";
        if (callback == null) {
            throw new IllegalArgumentException("A valid InitCallback required to ensure API calls are being made after initialize is successful");
        }
        if (context == null) {
            callback.onError(new VungleException(6));
            return;
        }
        final RuntimeValues runtimeValues = ServiceLocator.getInstance(context).getService(RuntimeValues.class);
        runtimeValues.settings = settings;
        final ServiceLocator serviceLocator = ServiceLocator.getInstance(context);
        Executors sdkExecutors = serviceLocator.getService(Executors.class);
        InitCallback initCallback = runtimeValues.initCallback = callback instanceof InitCallbackWrapper ? callback : new InitCallbackWrapper(sdkExecutors.getUIExecutor(), callback);
        if (appId == null || appId.isEmpty()) {
            runtimeValues.initCallback.onError(new VungleException(6));
            return;
        }
        if (!(context instanceof Application)) {
            runtimeValues.initCallback.onError(new VungleException(7));
            return;
        }
        if (Vungle.isInitialized()) {
            Log.d((String)TAG, (String)"init already complete");
            runtimeValues.initCallback.onSuccess();
            return;
        }
        if (isInitializing.getAndSet(true)) {
            Log.d((String)TAG, (String)"init ongoing");
            runtimeValues.initCallback.onError(new VungleException(8));
            return;
        }
        sdkExecutors.getVungleExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (!isDepInit.getAndSet(true)) {
                    CacheManager cacheManager = serviceLocator.getService(CacheManager.class);
                    if (runtimeValues.settings != null && cacheManager.getBytesAvailable() < runtimeValues.settings.getMinimumSpaceForInit()) {
                        if (runtimeValues.initCallback != null) {
                            runtimeValues.initCallback.onError(new VungleException(16));
                        }
                        Vungle.deInit();
                        return;
                    }
                    cacheManager.addListener(cacheListener);
                    _instance.context = context;
                    _instance.appID = appId;
                    Repository repository = serviceLocator.getService(Repository.class);
                    try {
                        repository.init();
                    }
                    catch (DatabaseHelper.DBException e) {
                        Vungle.onError(runtimeValues.initCallback, new VungleException(26));
                        Vungle.deInit();
                        return;
                    }
                    VungleApiClient vungleApiClient = serviceLocator.getService(VungleApiClient.class);
                    vungleApiClient.init(appId);
                    if (!TextUtils.isEmpty((CharSequence)_instance.userIMEI)) {
                        vungleApiClient.updateIMEI(_instance.userIMEI, _instance.shouldTransmitIMEI);
                    }
                    if (runtimeValues.settings != null) {
                        vungleApiClient.setDefaultIdFallbackDisabled(runtimeValues.settings.getAndroidIdOptOut());
                    }
                    JobRunner jobRunner = serviceLocator.getService(JobRunner.class);
                    AdLoader adLoader = serviceLocator.getService(AdLoader.class);
                    adLoader.init(jobRunner);
                    if (_instance.consent != null && !TextUtils.isEmpty((CharSequence)_instance.consentVersion)) {
                        Vungle.updateConsentStatus(_instance.consent, _instance.consentVersion);
                    } else {
                        Cookie gdprConsent = repository.load("consentIsImportantToVungle", Cookie.class).get();
                        if (gdprConsent == null) {
                            _instance.consent = null;
                            _instance.consentVersion = null;
                        } else {
                            _instance.consent = Vungle.getConsent(gdprConsent);
                            _instance.consentVersion = Vungle.getConsentMessageVersion(gdprConsent);
                        }
                    }
                    Cookie appIdCookie = repository.load("appId", Cookie.class).get();
                    if (appIdCookie == null) {
                        appIdCookie = new Cookie("appId");
                    }
                    appIdCookie.putValue("appId", appId);
                    try {
                        repository.save(appIdCookie);
                    }
                    catch (DatabaseHelper.DBException e) {
                        Vungle.onError(runtimeValues.initCallback, new VungleException(16));
                        Vungle.deInit();
                        return;
                    }
                }
                _instance.configure(runtimeValues.initCallback);
            }
        });
    }

    private static void onError(InitCallback initCallback, VungleException e) {
        if (initCallback != null) {
            initCallback.onError(e);
        }
    }

    static void reConfigure() {
        if (Vungle._instance.context == null) {
            return;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        Executors sdkExecutors = serviceLocator.getService(Executors.class);
        final RuntimeValues runtimeValues = serviceLocator.getService(RuntimeValues.class);
        if (Vungle.isInitialized()) {
            sdkExecutors.getVungleExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    _instance.configure(runtimeValues.initCallback);
                }
            });
        } else {
            Vungle.init(Vungle._instance.appID, Vungle._instance.context, runtimeValues.initCallback);
        }
    }

    private static void dropDownloaderCache(String advertisementId) {
        if (Vungle._instance.context == null) {
            return;
        }
        ServiceLocator.getInstance(Vungle._instance.context).getService(AdLoader.class).dropCache(advertisementId);
    }

    private void configure(@NonNull InitCallback callback) {
        try {
            JsonObject attributionReporting;
            JsonObject jsonObject;
            JsonArray placementsData;
            if (this.context == null) {
                throw new IllegalArgumentException("Context is null");
            }
            ServiceLocator serviceLocator = ServiceLocator.getInstance(this.context);
            VungleApiClient vungleApiClient = serviceLocator.getService(VungleApiClient.class);
            Repository repository = serviceLocator.getService(Repository.class);
            JobRunner jobRunner = serviceLocator.getService(JobRunner.class);
            Response<JsonObject> response = vungleApiClient.config();
            if (response == null) {
                callback.onError(new VungleException(2));
                isInitializing.set(false);
                return;
            }
            if (!response.isSuccessful()) {
                long retryAfterHeaderValue = vungleApiClient.getRetryAfterHeaderValue(response);
                if (retryAfterHeaderValue > 0L) {
                    jobRunner.execute(ReconfigJob.makeJobInfo(Vungle._instance.appID).setDelay(retryAfterHeaderValue));
                    callback.onError(new VungleException(14));
                    isInitializing.set(false);
                    return;
                }
                callback.onError(new VungleException(3));
                isInitializing.set(false);
                return;
            }
            final SharedPreferences preferences = this.context.getSharedPreferences(COM_VUNGLE_SDK, 0);
            if (!preferences.getBoolean("reported", false)) {
                vungleApiClient.reportNew().enqueue((Callback)new Callback<JsonObject>(){

                    public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                        if (response.isSuccessful()) {
                            SharedPreferences.Editor editor = preferences.edit();
                            editor.putBoolean("reported", true);
                            editor.apply();
                            Log.d((String)TAG, (String)"Saving reported state to shared preferences");
                        }
                    }

                    public void onFailure(Call<JsonObject> call, Throwable throwable) {
                    }
                });
            }
            if ((placementsData = (jsonObject = (JsonObject)response.body()).getAsJsonArray("placements")).size() == 0) {
                callback.onError(new VungleException(0));
                isInitializing.set(false);
                return;
            }
            CleverCacheSettings settings = CleverCacheSettings.fromJson(jsonObject);
            Downloader downloader = serviceLocator.getService(Downloader.class);
            if (settings != null) {
                boolean timestampChanged;
                CleverCacheSettings currentCacheSettings = CleverCacheSettings.deserializeFromString(preferences.getString("clever_cache", null));
                boolean bl = timestampChanged = currentCacheSettings == null || currentCacheSettings.getTimestamp() != settings.getTimestamp();
                if (!settings.isEnabled() || timestampChanged) {
                    downloader.clearCache();
                }
                downloader.setCacheEnabled(settings.isEnabled());
                preferences.edit().putString("clever_cache", settings.serializeToString()).apply();
            } else {
                downloader.setCacheEnabled(true);
            }
            AdLoader adLoader = serviceLocator.getService(AdLoader.class);
            ArrayList<Placement> newPlacements = new ArrayList<Placement>();
            for (JsonElement jsonElement : placementsData) {
                newPlacements.add(new Placement(jsonElement.getAsJsonObject()));
            }
            repository.setValidPlacements(newPlacements);
            if (jsonObject.has("gdpr")) {
                JsonObject gdprJsonObject;
                Cookie gdprConsent = repository.load("consentIsImportantToVungle", Cookie.class).get();
                if (gdprConsent == null) {
                    gdprConsent = new Cookie("consentIsImportantToVungle");
                    gdprConsent.putValue("consent_status", "unknown");
                    gdprConsent.putValue("consent_source", "no_interaction");
                    gdprConsent.putValue("timestamp", 0L);
                }
                boolean isCountryDataProtected = JsonUtil.hasNonNull((JsonElement)(gdprJsonObject = jsonObject.getAsJsonObject("gdpr")), "is_country_data_protected") && gdprJsonObject.get("is_country_data_protected").getAsBoolean();
                String consentTitle = JsonUtil.hasNonNull((JsonElement)gdprJsonObject, "consent_title") ? gdprJsonObject.get("consent_title").getAsString() : "";
                String consentMessage = JsonUtil.hasNonNull((JsonElement)gdprJsonObject, "consent_message") ? gdprJsonObject.get("consent_message").getAsString() : "";
                String consentMessageVersion = JsonUtil.hasNonNull((JsonElement)gdprJsonObject, "consent_message_version") ? gdprJsonObject.get("consent_message_version").getAsString() : "";
                String acceptText = JsonUtil.hasNonNull((JsonElement)gdprJsonObject, "button_accept") ? gdprJsonObject.get("button_accept").getAsString() : "";
                String denyText = JsonUtil.hasNonNull((JsonElement)gdprJsonObject, "button_deny") ? gdprJsonObject.get("button_deny").getAsString() : "";
                gdprConsent.putValue("is_country_data_protected", isCountryDataProtected);
                gdprConsent.putValue("consent_title", TextUtils.isEmpty((CharSequence)consentTitle) ? "Targeted Ads" : consentTitle);
                gdprConsent.putValue("consent_message", TextUtils.isEmpty((CharSequence)consentMessage) ? "To receive more relevant ad content based on your interactions with our ads, click \"I Consent\" below. Either way, you will see the same amount of ads." : consentMessage);
                String strGDPRCurrentSource = gdprConsent.getString("consent_source");
                if (!"publisher".equalsIgnoreCase(strGDPRCurrentSource)) {
                    gdprConsent.putValue("consent_message_version", TextUtils.isEmpty((CharSequence)consentMessageVersion) ? "" : consentMessageVersion);
                }
                gdprConsent.putValue("button_accept", TextUtils.isEmpty((CharSequence)acceptText) ? "I Consent" : acceptText);
                gdprConsent.putValue("button_deny", TextUtils.isEmpty((CharSequence)denyText) ? "I Do Not Consent" : denyText);
                repository.save(gdprConsent);
            }
            int directDownloadStatus = -1;
            if (jsonObject.has("apk_direct_download") && jsonObject.getAsJsonObject("apk_direct_download").has("enabled")) {
                JsonObject ddObj = jsonObject.getAsJsonObject("apk_direct_download");
                boolean isDirectDownloadEnabled = ddObj.get("enabled").getAsBoolean();
                directDownloadStatus = isDirectDownloadEnabled ? 1 : 0;
            }
            ApkDownloadManager.getInstance().init(this.context, directDownloadStatus);
            if (jsonObject.has("ri")) {
                Cookie configCookie = repository.load("configSettings", Cookie.class).get();
                if (configCookie == null) {
                    configCookie = new Cookie("configSettings");
                }
                boolean isReportIncentivizedEnabled = jsonObject.getAsJsonObject("ri").get("enabled").getAsBoolean();
                configCookie.putValue("isReportIncentivizedEnabled", isReportIncentivizedEnabled);
                repository.save(configCookie);
            }
            this.shouldTransmitIMEI = jsonObject.has("attribution_reporting") ? ((attributionReporting = jsonObject.getAsJsonObject("attribution_reporting")).has("should_transmit_imei") ? attributionReporting.get("should_transmit_imei").getAsBoolean() : false) : false;
            if (jsonObject.has("config")) {
                long sleep = jsonObject.getAsJsonObject("config").get("refresh_time").getAsLong();
                jobRunner.execute(ReconfigJob.makeJobInfo(this.appID).setDelay(sleep));
            }
            try {
                serviceLocator.getService(VisionController.class).setConfig(JsonUtil.hasNonNull((JsonElement)jsonObject, "vision") ? (VisionConfig)this.gson.fromJson((JsonElement)jsonObject.getAsJsonObject("vision"), VisionConfig.class) : new VisionConfig());
            }
            catch (DatabaseHelper.DBException dbException) {
                Log.e((String)TAG, (String)"not able to apply vision data config");
            }
            isInitialized = true;
            callback.onSuccess();
            isInitializing.set(false);
            Collection<Placement> placements = repository.loadValidPlacements().get();
            jobRunner.execute(CleanupJob.makeJobInfo());
            if (placements != null) {
                for (Placement placement : placements) {
                    if (!placement.isAutoCached()) continue;
                    Log.d((String)TAG, (String)"starting jobs for autocached advs");
                    adLoader.loadEndless(placement.getId(), placement.getAdSize(), 0L);
                }
            }
            jobRunner.execute(SendReportsJob.makeJobInfo(true));
        }
        catch (Throwable throwable) {
            isInitialized = false;
            isInitializing.set(false);
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)throwable));
            if (throwable instanceof HttpException) {
                callback.onError(new VungleException(3));
            }
            if (throwable instanceof DatabaseHelper.DBException) {
                callback.onError(new VungleException(26));
            }
            callback.onError(new VungleException(2));
        }
    }

    public static boolean isInitialized() {
        Repository repository;
        Collection<String> placements;
        return isInitialized && Vungle._instance.context != null && (placements = (repository = ServiceLocator.getInstance(Vungle._instance.context).getService(Repository.class)).getValidPlacements().get()) != null && placements.size() > 0;
    }

    public static void setIncentivizedFields(final @Nullable String userID, final @Nullable String title, final @Nullable String body, final @Nullable String keepWatching, final @Nullable String close) {
        if (Vungle._instance.context == null) {
            Log.e((String)TAG, (String)"Vungle is not initialized, context is null");
            return;
        }
        final ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        serviceLocator.getService(SDKExecutors.class).getVungleExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (!Vungle.isInitialized()) {
                    Log.e((String)TAG, (String)"Vungle is not initialized");
                    return;
                }
                Repository repository = serviceLocator.getService(Repository.class);
                Cookie incentivizedCookie = repository.load("incentivizedTextSetByPub", Cookie.class).get();
                if (incentivizedCookie == null) {
                    incentivizedCookie = new Cookie("incentivizedTextSetByPub");
                }
                boolean changed = false;
                if (!TextUtils.isEmpty((CharSequence)title)) {
                    changed = true;
                    incentivizedCookie.putValue("title", title);
                }
                if (!TextUtils.isEmpty((CharSequence)body)) {
                    changed = true;
                    incentivizedCookie.putValue("body", body);
                }
                if (!TextUtils.isEmpty((CharSequence)keepWatching)) {
                    changed = true;
                    incentivizedCookie.putValue("continue", keepWatching);
                }
                if (!TextUtils.isEmpty((CharSequence)close)) {
                    changed = true;
                    incentivizedCookie.putValue("close", close);
                }
                if (!TextUtils.isEmpty((CharSequence)userID)) {
                    changed = true;
                    incentivizedCookie.putValue("userID", userID);
                }
                if (changed) {
                    try {
                        repository.save(incentivizedCookie);
                    }
                    catch (DatabaseHelper.DBException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public static boolean canPlayAd(@NonNull String id) {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized");
            return false;
        }
        Advertisement advertisement = ServiceLocator.getInstance(Vungle._instance.context).getService(Repository.class).findValidAdvertisementForPlacement(id).get();
        Placement placement = ServiceLocator.getInstance(Vungle._instance.context).getService(Repository.class).load(id, Placement.class).get();
        if (advertisement == null || placement == null) {
            return false;
        }
        if (placement.getPlacementAdType() != 0 || !AdConfig.AdSize.isDefaultAdSize(placement.getAdSize()) && !placement.getAdSize().equals((Object)advertisement.getAdConfig().getAdSize())) {
            return false;
        }
        return Vungle.canPlayAd(advertisement);
    }

    static boolean canPlayAd(Advertisement advertisement) {
        if (Vungle._instance.context == null) {
            return false;
        }
        return ServiceLocator.getInstance(Vungle._instance.context).getService(AdLoader.class).canPlayAd(advertisement);
    }

    public static void playAd(final @NonNull String id, final AdConfig settings, @Nullable PlayAdCallback callback) {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Locator is not initialized");
            if (callback != null) {
                callback.onError(id, new VungleException(9));
            }
            return;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        final Executors sdkExecutors = serviceLocator.getService(Executors.class);
        final Repository repository = serviceLocator.getService(Repository.class);
        final AdLoader adLoader = serviceLocator.getService(AdLoader.class);
        final VungleApiClient vungleApiClient = serviceLocator.getService(VungleApiClient.class);
        final PlayAdCallbackWrapper listener = new PlayAdCallbackWrapper(sdkExecutors.getUIExecutor(), callback);
        sdkExecutors.getVungleExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (Boolean.TRUE.equals(_instance.playOperations.get(id)) || adLoader.isLoading(id)) {
                    listener.onError(id, new VungleException(8));
                    return;
                }
                Placement placement = repository.load(id, Placement.class).get();
                if (placement == null) {
                    listener.onError(id, new VungleException(13));
                    return;
                }
                if (AdConfig.AdSize.isBannerAdSize(placement.getAdSize())) {
                    listener.onError(id, new VungleException(28));
                    return;
                }
                boolean streamingOnly = false;
                Advertisement advertisement = repository.findValidAdvertisementForPlacement(id).get();
                try {
                    if (!Vungle.canPlayAd(advertisement)) {
                        streamingOnly = true;
                        if (advertisement != null && advertisement.getState() == 1) {
                            repository.saveAndApplyState(advertisement, id, 4);
                            if (placement.isAutoCached()) {
                                adLoader.loadEndless(placement.getId(), placement.getAdSize(), 0L);
                            }
                        }
                    } else {
                        advertisement.configure(settings);
                        repository.save(advertisement);
                    }
                }
                catch (DatabaseHelper.DBException ignored) {
                    listener.onError(id, new VungleException(26));
                    return;
                }
                if (_instance.context != null) {
                    final boolean finalStreamingOnly = streamingOnly;
                    final Advertisement finalAdvertisement = advertisement;
                    if (vungleApiClient.canCallWillPlayAd()) {
                        vungleApiClient.willPlayAd(placement.getId(), placement.isAutoCached(), streamingOnly ? "" : advertisement.getAdToken()).enqueue((Callback)new Callback<JsonObject>(){

                            public void onResponse(Call<JsonObject> call, final Response<JsonObject> response) {
                                sdkExecutors.getVungleExecutor().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        JsonObject responseBody;
                                        Advertisement streamingAd = null;
                                        if (response.isSuccessful() && (responseBody = (JsonObject)response.body()) != null && responseBody.has("ad")) {
                                            try {
                                                JsonObject adJson = responseBody.getAsJsonObject("ad");
                                                streamingAd = new Advertisement(adJson);
                                                streamingAd.configure(settings);
                                                repository.saveAndApplyState(streamingAd, id, 0);
                                            }
                                            catch (IllegalArgumentException e) {
                                                Log.v((String)TAG, (String)"Will Play Ad did not respond with a replacement. Move on.");
                                            }
                                            catch (Exception e) {
                                                Log.e((String)TAG, (String)"Error using will_play_ad!", (Throwable)e);
                                            }
                                        }
                                        if (finalStreamingOnly) {
                                            if (streamingAd == null) {
                                                listener.onError(id, new VungleException(1));
                                            } else {
                                                Vungle.renderAd(id, listener, id, streamingAd);
                                            }
                                        } else {
                                            Vungle.renderAd(id, listener, id, finalAdvertisement);
                                        }
                                    }
                                });
                            }

                            public void onFailure(Call<JsonObject> call, Throwable throwable) {
                                sdkExecutors.getVungleExecutor().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (finalStreamingOnly) {
                                            listener.onError(id, new VungleException(1));
                                        } else {
                                            Vungle.renderAd(id, listener, id, finalAdvertisement);
                                        }
                                    }
                                });
                            }
                        });
                    } else if (finalStreamingOnly) {
                        listener.onError(id, new VungleException(1));
                    } else {
                        Vungle.renderAd(id, listener, id, finalAdvertisement);
                    }
                }
            }
        });
    }

    private static synchronized void renderAd(@NonNull String id, final @Nullable PlayAdCallback listener, final String placementId, final Advertisement advertisement) {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Sdk is not initilized");
            return;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        final Repository repository = serviceLocator.getService(Repository.class);
        final AdLoader adLoader = serviceLocator.getService(AdLoader.class);
        final JobRunner jobRunner = serviceLocator.getService(JobRunner.class);
        final VisionController visionController = serviceLocator.getService(VisionController.class);
        Vungle._instance.playOperations.put(id, true);
        VungleActivity.setEventListener(new AdContract.AdvertisementPresenter.EventListener(){
            boolean successfulView;
            int percentViewed = -1;

            @Override
            public void onNext(String event, String value, String id) {
                try {
                    String[] tokens;
                    if (event.equals("start")) {
                        repository.saveAndApplyState(advertisement, id, 2);
                        if (listener != null) {
                            listener.onAdStart(id);
                        }
                        this.percentViewed = 0;
                        Placement placement = repository.load(placementId, Placement.class).get();
                        if (placement != null && placement.isAutoCached()) {
                            adLoader.loadEndless(placementId, placement.getAdSize(), 0L);
                        }
                    } else if (event.equals("end")) {
                        Log.d((String)"Vungle", (String)("Cleaning up metadata and assets for placement " + id + " and advertisement " + advertisement.getId()));
                        repository.saveAndApplyState(advertisement, id, 3);
                        repository.updateAndSaveReportState(id, advertisement.getAppID(), 0, 1);
                        VungleActivity.setEventListener(null);
                        _instance.playOperations.put(id, false);
                        jobRunner.execute(SendReportsJob.makeJobInfo(false));
                        if (listener != null) {
                            listener.onAdEnd(id, this.successfulView || this.percentViewed >= 80, value != null && value.equals("isCTAClicked"));
                        }
                        if (visionController.isEnabled()) {
                            visionController.reportData(advertisement.getCreativeId(), advertisement.getCampaignId(), advertisement.getAdvertiserAppId());
                        }
                    } else if (event.equals("successfulView")) {
                        this.successfulView = true;
                    } else if (event.startsWith("percentViewed") && (tokens = event.split(":")).length == 2) {
                        String percentString = tokens[1];
                        this.percentViewed = Integer.parseInt(percentString);
                    }
                }
                catch (DatabaseHelper.DBException ignored) {
                    this.onError(new VungleException(26), id);
                }
            }

            @Override
            public void onError(@NonNull VungleException exception, String id) {
                if (exception.getExceptionCode() == 27) {
                    Vungle.dropDownloaderCache(advertisement.getId());
                    return;
                }
                if (exception.getExceptionCode() != 15 && exception.getExceptionCode() != 25) {
                    try {
                        repository.saveAndApplyState(advertisement, id, 4);
                    }
                    catch (DatabaseHelper.DBException e) {
                        exception = new VungleException(26);
                    }
                }
                VungleActivity.setEventListener(null);
                _instance.playOperations.put(id, false);
                if (listener != null) {
                    listener.onError(id, exception);
                }
            }
        });
        boolean isFlex = advertisement != null && "flexview".equals(advertisement.getTemplateType());
        Intent intent = new Intent(Vungle._instance.context, isFlex ? VungleFlexViewActivity.class : VungleActivity.class);
        intent.addFlags(0x10000000);
        intent.putExtra("placement", id);
        Vungle._instance.context.startActivity(intent);
    }

    public static void loadAd(@NonNull String id, @Nullable LoadAdCallback callback) {
        Vungle.loadAd(id, new AdConfig(), callback);
    }

    public static void loadAd(final @NonNull String id, final @Nullable AdConfig adConfig, final @Nullable LoadAdCallback callback) {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized");
            if (callback != null) {
                callback.onError(id, new VungleException(9));
            }
            return;
        }
        ServiceLocator.getInstance(Vungle._instance.context).getService(Repository.class).load(id, Placement.class, new Repository.LoadCallback<Placement>(){

            @Override
            public void onLoaded(Placement result) {
                if (result == null) {
                    if (callback != null) {
                        callback.onError(id, new VungleException(13));
                    }
                } else if (adConfig != null && !AdConfig.AdSize.isDefaultAdSize(adConfig.getAdSize())) {
                    if (callback != null) {
                        callback.onError(id, new VungleException(29));
                    }
                } else {
                    Vungle.loadAdInternal(id, adConfig, callback);
                }
            }
        });
    }

    static void loadAdInternal(@NonNull String id, @Nullable AdConfig adConfig, @Nullable LoadAdCallback callback) {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized");
            if (callback != null) {
                callback.onError(id, new VungleException(9));
            }
            return;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        LoadAdCallbackWrapper listener = new LoadAdCallbackWrapper(serviceLocator.getService(SDKExecutors.class).getUIExecutor(), callback);
        serviceLocator.getService(AdLoader.class).load(id, adConfig == null ? new AdConfig() : adConfig, listener);
    }

    private static void clearCache() {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized");
            return;
        }
        final ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        serviceLocator.getService(SDKExecutors.class).getVungleExecutor().execute(new Runnable(){

            @Override
            public void run() {
                serviceLocator.getService(Downloader.class).cancelAll();
                serviceLocator.getService(Repository.class).clearAllData();
                RuntimeValues runtimeValues = serviceLocator.getService(RuntimeValues.class);
                serviceLocator.getService(AdLoader.class).clear();
                _instance.playOperations.clear();
                _instance.configure(runtimeValues.initCallback);
            }
        });
    }

    @Nullable
    public static VungleNativeAd getNativeAd(@NonNull String placementId, @Nullable AdConfig adConfig, @Nullable PlayAdCallback playAdCallback) {
        if (adConfig == null) {
            adConfig = new AdConfig();
        }
        if (AdConfig.AdSize.isDefaultAdSize(adConfig.getAdSize())) {
            return Vungle.getNativeAdInternal(placementId, adConfig, playAdCallback);
        }
        if (playAdCallback != null) {
            Log.e((String)TAG, (String)"Please use Banners.getBanner(... ) to retrieve Banner Ad");
            playAdCallback.onError(placementId, new VungleException(29));
        }
        return null;
    }

    @Nullable
    static VungleNativeView getNativeAdInternal(String placementId, AdConfig adConfig, final PlayAdCallback playAdCallback) {
        VungleNativeView nativeView;
        block24: {
            if (!Vungle.isInitialized()) {
                Log.e((String)TAG, (String)"Vungle is not initialized, returned VungleNativeAd = null");
                if (playAdCallback != null) {
                    playAdCallback.onError(placementId, new VungleException(9));
                }
                return null;
            }
            ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
            final Repository repository = serviceLocator.getService(Repository.class);
            final AdLoader adLoader = serviceLocator.getService(AdLoader.class);
            final JobRunner jobRunner = serviceLocator.getService(JobRunner.class);
            final VisionController visionController = serviceLocator.getService(VisionController.class);
            Placement placement = repository.load(placementId, Placement.class).get();
            if (placement == null) {
                Log.e((String)TAG, (String)"No Placement for ID");
                if (playAdCallback != null) {
                    playAdCallback.onError(placementId, new VungleException(13));
                }
                return null;
            }
            final Advertisement advertisement = repository.findValidAdvertisementForPlacement(placementId).get();
            if (advertisement == null) {
                Log.e((String)TAG, (String)"No Advertisement for ID");
                if (playAdCallback != null) {
                    playAdCallback.onError(placementId, new VungleException(10));
                }
                return null;
            }
            if (!Vungle.canPlayAd(advertisement)) {
                if (advertisement.getState() == 1) {
                    block23: {
                        try {
                            repository.saveAndApplyState(advertisement, placementId, 4);
                        }
                        catch (DatabaseHelper.DBException e) {
                            if (playAdCallback == null) break block23;
                            playAdCallback.onError(placementId, new VungleException(26));
                        }
                    }
                    if (placement.isAutoCached()) {
                        adLoader.loadEndless(placement.getId(), placement.getAdSize(), 0L);
                    }
                }
                if (playAdCallback != null) {
                    playAdCallback.onError(placementId, new VungleException(10));
                }
                return null;
            }
            if (Boolean.TRUE.equals(Vungle._instance.playOperations.get(placementId)) || adLoader.isLoading(placementId)) {
                Log.e((String)TAG, (String)("Playing or Loading operation ongoing. Playing " + Vungle._instance.playOperations.get(placementId) + " Loading: " + adLoader.isLoading(placementId)));
                if (playAdCallback != null) {
                    playAdCallback.onError(placementId, new VungleException(8));
                }
                return null;
            }
            if (advertisement.getAdType() != 1) {
                Log.e((String)TAG, (String)"Invalid Ad Type for Native Ad.");
                if (playAdCallback != null) {
                    playAdCallback.onError(placementId, new VungleException(10));
                }
                return null;
            }
            if ("mrec".equals(advertisement.getTemplateType()) && adConfig.getAdSize() != AdConfig.AdSize.VUNGLE_MREC || "flexfeed".equals(advertisement.getTemplateType()) && adConfig.getAdSize() != AdConfig.AdSize.VUNGLE_DEFAULT) {
                Log.e((String)TAG, (String)"Corresponding AdConfig#setAdSize must be passed for the type/size of native ad");
                if (playAdCallback != null) {
                    playAdCallback.onError(placementId, new VungleException(28));
                }
                return null;
            }
            advertisement.configure(adConfig);
            try {
                repository.save(advertisement);
            }
            catch (DatabaseHelper.DBException e) {
                if (playAdCallback != null) {
                    playAdCallback.onError(placementId, new VungleException(26));
                }
                return null;
            }
            Vungle._instance.playOperations.put(placementId, true);
            nativeView = null;
            try {
                nativeView = new VungleNativeView(Vungle._instance.context.getApplicationContext(), placementId, serviceLocator.getService(PresentationFactory.class), new AdContract.AdvertisementPresenter.EventListener(){
                    boolean successfulView;
                    int percentViewed = -1;

                    @Override
                    public void onNext(String s, String value, String placementId) {
                        try {
                            String[] tokens;
                            if (s.equals("start")) {
                                repository.saveAndApplyState(advertisement, placementId, 2);
                                if (playAdCallback != null) {
                                    playAdCallback.onAdStart(placementId);
                                }
                                this.percentViewed = 0;
                                Placement placement = repository.load(placementId, Placement.class).get();
                                if (placement != null && placement.isAutoCached()) {
                                    adLoader.loadEndless(placementId, placement.getAdSize(), 0L);
                                }
                            } else if (s.equals("end")) {
                                Log.d((String)"Vungle", (String)("Cleaning up metadata and assets for placement " + placementId + " and advertisement " + advertisement.getId()));
                                repository.saveAndApplyState(advertisement, placementId, 3);
                                repository.updateAndSaveReportState(placementId, advertisement.getAppID(), 0, 1);
                                jobRunner.execute(SendReportsJob.makeJobInfo(false));
                                _instance.playOperations.put(placementId, false);
                                if (playAdCallback != null) {
                                    playAdCallback.onAdEnd(placementId, this.successfulView || this.percentViewed >= 80, value != null && value.equals("isCTAClicked"));
                                }
                                if (visionController.isEnabled()) {
                                    visionController.reportData(advertisement.getCreativeId(), advertisement.getCampaignId(), advertisement.getAdvertiserAppId());
                                }
                            } else if (s.equals("successfulView")) {
                                this.successfulView = true;
                            } else if (s.startsWith("percentViewed") && (tokens = s.split(":")).length == 2) {
                                String percentString = tokens[1];
                                this.percentViewed = Integer.parseInt(percentString);
                            }
                        }
                        catch (DatabaseHelper.DBException ignored) {
                            this.onError(new VungleException(26), placementId);
                        }
                    }

                    @Override
                    public void onError(VungleException exception, String placementId) {
                        if (exception.getExceptionCode() == 27) {
                            Vungle.dropDownloaderCache(advertisement.getId());
                            return;
                        }
                        _instance.playOperations.put(placementId, false);
                        if (exception.getExceptionCode() != 25) {
                            try {
                                repository.saveAndApplyState(advertisement, placementId, 4);
                            }
                            catch (DatabaseHelper.DBException e) {
                                exception = new VungleException(26);
                            }
                        }
                        if (playAdCallback != null) {
                            playAdCallback.onError(placementId, exception);
                        }
                    }
                });
            }
            catch (Exception ex) {
                Vungle._instance.playOperations.put(placementId, false);
                if (playAdCallback == null) break block24;
                playAdCallback.onError(placementId, new VungleException(10));
            }
        }
        return nativeView;
    }

    public static Collection<String> getValidPlacements() {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized return empty placements list");
            return Collections.emptyList();
        }
        Repository repository = ServiceLocator.getInstance(Vungle._instance.context).getService(Repository.class);
        Collection<String> placements = repository.getValidPlacements().get();
        if (placements == null) {
            return Collections.emptyList();
        }
        return placements;
    }

    public static void updateConsentStatus(final @NonNull Consent status, final @NonNull String consentMessageVersion) {
        Vungle._instance.consent = status;
        Vungle._instance.consentVersion = consentMessageVersion;
        if (!Vungle.isInitialized() || !isDepInit.get()) {
            Log.e((String)TAG, (String)"Vungle is not initialized");
            return;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        final Repository repository = serviceLocator.getService(Repository.class);
        repository.load("consentIsImportantToVungle", Cookie.class, new Repository.LoadCallback<Cookie>(){

            @Override
            public void onLoaded(Cookie gdprConsent) {
                if (gdprConsent == null) {
                    gdprConsent = new Cookie("consentIsImportantToVungle");
                }
                gdprConsent.putValue("consent_status", status == Consent.OPTED_IN ? "opted_in" : "opted_out");
                gdprConsent.putValue("timestamp", System.currentTimeMillis() / 1000L);
                gdprConsent.putValue("consent_source", "publisher");
                gdprConsent.putValue("consent_message_version", consentMessageVersion == null ? "" : consentMessageVersion);
                repository.save(gdprConsent, null);
            }
        });
    }

    public static Consent getConsentStatus() {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized, consent is null");
            return null;
        }
        return Vungle._instance.consent;
    }

    public static String getConsentMessageVersion() {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized, please wait initialize or wait until Vungle is intialized to get Consent Message Version");
            return null;
        }
        return Vungle._instance.consentVersion;
    }

    private static Consent getConsent(Cookie gdprConsent) {
        if (gdprConsent == null) {
            return null;
        }
        return "opted_in".equals(gdprConsent.getString("consent_status")) ? Consent.OPTED_IN : Consent.OPTED_OUT;
    }

    private static String getConsentMessageVersion(Cookie gdprConsent) {
        if (gdprConsent == null) {
            return null;
        }
        return gdprConsent.getString("consent_message_version");
    }

    public static boolean closeFlexViewAd(@NonNull String placementReferenceId) {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized, can't close flex view ad");
            return false;
        }
        Intent broadcast = new Intent("AdvertisementBus");
        broadcast.putExtra("placement", placementReferenceId);
        broadcast.putExtra("command", "closeFlex");
        LocalBroadcastManager.getInstance((Context)Vungle._instance.context).sendBroadcast(broadcast);
        return true;
    }

    public static void setUserLegacyID(String legacyId) {
        if (!Vungle.isInitialized() && !isInitializing.get()) {
            Vungle._instance.userIMEI = legacyId;
        } else {
            ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
            serviceLocator.getService(VungleApiClient.class).updateIMEI(legacyId, Vungle._instance.shouldTransmitIMEI);
        }
    }

    public static void setHeaderBiddingCallback(HeaderBiddingCallback headerBiddingCallback) {
        if (Vungle._instance.context == null) {
            return;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        RuntimeValues runtimeValues = serviceLocator.getService(RuntimeValues.class);
        runtimeValues.headerBiddingCallback = new HeaderBiddingCallbackWrapper(serviceLocator.getService(SDKExecutors.class).getUIExecutor(), headerBiddingCallback);
    }

    protected static void deInit() {
        if (Vungle._instance.context != null) {
            ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
            serviceLocator.getService(CacheManager.class).removeListener(cacheListener);
            serviceLocator.getService(Downloader.class).cancelAll();
            serviceLocator.getService(AdLoader.class).clear();
            Vungle._instance.playOperations.clear();
        }
        ServiceLocator.deInit();
        isInitialized = false;
        isDepInit.set(false);
        isInitializing.set(false);
    }

    private static void stopPlaying() {
        if (Vungle._instance.context == null) {
            return;
        }
        Intent broadcast = new Intent("AdvertisementBus");
        broadcast.putExtra("command", "stopAll");
        LocalBroadcastManager.getInstance((Context)Vungle._instance.context).sendBroadcast(broadcast);
    }

    @Nullable
    static Context appContext() {
        if (_instance != null) {
            return Vungle._instance.context;
        }
        return null;
    }

    static {
        isInitializing = new AtomicBoolean(false);
        isDepInit = new AtomicBoolean(false);
        cacheListener = new CacheManager.Listener(){

            @Override
            public void onCacheChanged() {
                if (_instance.context == null) {
                    return;
                }
                Vungle.stopPlaying();
                ServiceLocator serviceLocator = ServiceLocator.getInstance(_instance.context);
                CacheManager cacheManager = serviceLocator.getService(CacheManager.class);
                Downloader downloader = serviceLocator.getService(Downloader.class);
                if (cacheManager.getCache() != null) {
                    List<DownloadRequest> requests = downloader.getAllRequests();
                    String newPath = cacheManager.getCache().getPath();
                    for (DownloadRequest request : requests) {
                        if (request.path.startsWith(newPath)) continue;
                        downloader.cancel(request);
                    }
                }
                downloader.init();
            }
        };
    }

    @Keep
    public static enum Consent {
        OPTED_IN,
        OPTED_OUT;

    }
}

