/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.vungle.warren.AdLoader;
import com.vungle.warren.AdvertisementPresentationFactory;
import com.vungle.warren.DownloaderSizeProvider;
import com.vungle.warren.PresentationFactory;
import com.vungle.warren.RuntimeValues;
import com.vungle.warren.VisionController;
import com.vungle.warren.Vungle;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.VungleJobRunner;
import com.vungle.warren.VungleStaticApi;
import com.vungle.warren.analytics.VungleAnalytics;
import com.vungle.warren.downloader.AssetDownloader;
import com.vungle.warren.downloader.CleverCache;
import com.vungle.warren.downloader.Downloader;
import com.vungle.warren.downloader.DownloaderCache;
import com.vungle.warren.downloader.LRUCachePolicy;
import com.vungle.warren.persistence.CacheManager;
import com.vungle.warren.persistence.Designer;
import com.vungle.warren.persistence.GraphicDesigner;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.tasks.JobCreator;
import com.vungle.warren.tasks.JobRunner;
import com.vungle.warren.tasks.ReconfigJob;
import com.vungle.warren.tasks.VungleJobCreator;
import com.vungle.warren.tasks.utility.JobRunnerThreadPriorityHelper;
import com.vungle.warren.utility.Executors;
import com.vungle.warren.utility.NetworkProvider;
import com.vungle.warren.utility.SDKExecutors;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class ServiceLocator {
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile ServiceLocator INSTANCE;
    private final Context ctx;
    private Map<Class, Creator> creators = new HashMap<Class, Creator>();
    private Map<Class, Object> cache = new HashMap<Class, Object>();
    private static final VungleStaticApi vungleApi;
    private static ReconfigJob.ReconfigCall reconfigCall;

    private ServiceLocator(@NonNull Context context) {
        this.ctx = context.getApplicationContext();
        this.buildCreators();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ServiceLocator getInstance(@NonNull Context context) {
        if (INSTANCE != null) return INSTANCE;
        Class<ServiceLocator> clazz = ServiceLocator.class;
        synchronized (ServiceLocator.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ServiceLocator(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    static synchronized void deInit() {
        INSTANCE = null;
    }

    synchronized <T> T getService(Class<T> serviceClass) {
        return this.getOrBuild(serviceClass);
    }

    private <T> T getOrBuild(@NonNull Class<T> serviceClass) {
        Class target = this.getServiceClass(serviceClass);
        Object value = this.cache.get(target);
        if (value == null || !target.isAssignableFrom(value.getClass())) {
            Creator creator = this.creators.get(serviceClass);
            if (creator == null) {
                throw new IllegalArgumentException("Unknown class");
            }
            value = creator.create();
            if (creator.isSingleton()) {
                this.cache.put(target, value);
            }
        }
        return (T)value;
    }

    @NonNull
    private Class getServiceClass(@NonNull Class serviceClass) {
        for (Class clazz : this.creators.keySet()) {
            if (!clazz.isAssignableFrom(serviceClass)) continue;
            return clazz;
        }
        throw new IllegalArgumentException("Unknown dependency for " + serviceClass);
    }

    @VisibleForTesting
    synchronized <T> void bindService(Class<T> tClass, T service) {
        this.cache.put(tClass, service);
    }

    private void buildCreators() {
        this.creators.put(JobCreator.class, new Creator(){

            public JobCreator create() {
                return new VungleJobCreator((Repository)ServiceLocator.this.getOrBuild(Repository.class), (Designer)ServiceLocator.this.getOrBuild(Designer.class), (VungleApiClient)ServiceLocator.this.getOrBuild(VungleApiClient.class), new VungleAnalytics((VungleApiClient)ServiceLocator.this.getOrBuild(VungleApiClient.class)), reconfigCall, (AdLoader)ServiceLocator.this.getOrBuild(AdLoader.class), vungleApi);
            }
        });
        this.creators.put(JobRunner.class, new Creator(){

            public JobRunner create() {
                return new VungleJobRunner((JobCreator)ServiceLocator.this.getOrBuild(JobCreator.class), ((Executors)ServiceLocator.this.getOrBuild(Executors.class)).getJobExecutor(), new JobRunnerThreadPriorityHelper(), NetworkProvider.getInstance(ServiceLocator.this.ctx));
            }
        });
        this.creators.put(AdLoader.class, new Creator(){

            public AdLoader create() {
                return new AdLoader((Executors)ServiceLocator.this.getOrBuild(Executors.class), (Repository)ServiceLocator.this.getOrBuild(Repository.class), (VungleApiClient)ServiceLocator.this.getOrBuild(VungleApiClient.class), (CacheManager)ServiceLocator.this.getOrBuild(CacheManager.class), (Downloader)ServiceLocator.this.getOrBuild(Downloader.class), (RuntimeValues)ServiceLocator.this.getOrBuild(RuntimeValues.class), (VungleStaticApi)ServiceLocator.this.getOrBuild(VungleStaticApi.class), (VisionController)ServiceLocator.this.getOrBuild(VisionController.class));
            }
        });
        this.creators.put(Downloader.class, new Creator(){

            public Downloader create() {
                return new AssetDownloader((DownloaderCache)ServiceLocator.this.getOrBuild(DownloaderCache.class), AssetDownloader.VERIFICATION_WINDOW, 4, NetworkProvider.getInstance(ServiceLocator.this.ctx), ((Executors)ServiceLocator.this.getOrBuild(Executors.class)).getUIExecutor());
            }
        });
        this.creators.put(VungleApiClient.class, new Creator(){

            public VungleApiClient create() {
                return new VungleApiClient(ServiceLocator.this.ctx, (CacheManager)ServiceLocator.this.getOrBuild(CacheManager.class), (Repository)ServiceLocator.this.getOrBuild(Repository.class));
            }
        });
        this.creators.put(Repository.class, new Creator(){

            public Repository create() {
                Executors sdkExecutors = (Executors)ServiceLocator.this.getOrBuild(Executors.class);
                return new Repository(ServiceLocator.this.ctx, (Designer)ServiceLocator.this.getOrBuild(Designer.class), sdkExecutors.getIOExecutor(), sdkExecutors.getUIExecutor());
            }
        });
        this.creators.put(Designer.class, new Creator(){

            public Designer create() {
                return new GraphicDesigner((CacheManager)ServiceLocator.this.getOrBuild(CacheManager.class));
            }
        });
        this.creators.put(CacheManager.class, new Creator(){

            public CacheManager create() {
                return new CacheManager(ServiceLocator.this.ctx);
            }
        });
        this.creators.put(Executors.class, new Creator(){

            public Executors create() {
                return new SDKExecutors();
            }
        });
        this.creators.put(RuntimeValues.class, new Creator(){

            public RuntimeValues create() {
                return new RuntimeValues();
            }
        });
        this.creators.put(VungleStaticApi.class, new Creator(){

            public VungleStaticApi create() {
                return vungleApi;
            }
        });
        this.creators.put(PresentationFactory.class, new Creator(){

            public PresentationFactory create() {
                return new AdvertisementPresentationFactory((AdLoader)ServiceLocator.this.getOrBuild(AdLoader.class), (VungleStaticApi)ServiceLocator.this.getOrBuild(VungleStaticApi.class), (Repository)ServiceLocator.this.getOrBuild(Repository.class), (VungleApiClient)ServiceLocator.this.getOrBuild(VungleApiClient.class), (JobRunner)ServiceLocator.this.getOrBuild(JobRunner.class), (Executors)ServiceLocator.this.getOrBuild(Executors.class));
            }

            @Override
            boolean isSingleton() {
                return false;
            }
        });
        this.creators.put(DownloaderCache.class, new Creator(){

            Object create() {
                CacheManager cacheManager = (CacheManager)ServiceLocator.this.getOrBuild(CacheManager.class);
                return new CleverCache(cacheManager, new LRUCachePolicy(cacheManager, "clever_cache"), new DownloaderSizeProvider(cacheManager, (RuntimeValues)ServiceLocator.this.getOrBuild(RuntimeValues.class), 0.1f), TimeUnit.DAYS.toMillis(90L));
            }
        });
        this.creators.put(VisionController.class, new Creator(){

            public VisionController create() {
                return new VisionController((Repository)ServiceLocator.this.getOrBuild(Repository.class), NetworkProvider.getInstance(ServiceLocator.this.ctx));
            }
        });
    }

    static {
        vungleApi = new VungleStaticApi(){

            @Override
            public boolean isInitialized() {
                return Vungle.isInitialized();
            }

            @Override
            public Collection<String> getValidPlacements() {
                return Vungle.getValidPlacements();
            }
        };
        reconfigCall = new ReconfigJob.ReconfigCall(){

            @Override
            public void reConfigVungle() {
                Vungle.reConfigure();
            }
        };
    }

    private abstract class Creator<T> {
        private Creator() {
        }

        abstract T create();

        boolean isSingleton() {
            return true;
        }
    }
}

