/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import androidx.annotation.NonNull;
import com.vungle.warren.RuntimeValues;
import com.vungle.warren.SizeProvider;
import com.vungle.warren.VungleSettings;
import com.vungle.warren.persistence.CacheManager;

public class DownloaderSizeProvider
implements SizeProvider {
    private final float cap;
    private CacheManager cacheManager;
    private RuntimeValues runtimeValues;

    public DownloaderSizeProvider(@NonNull CacheManager cacheManager, @NonNull RuntimeValues runtimeValues, float cap) {
        this.cacheManager = cacheManager;
        this.runtimeValues = runtimeValues;
        this.cap = cap;
    }

    @Override
    public long getTargetSize() {
        VungleSettings settings = this.runtimeValues.settings;
        if (settings == null) {
            return 0L;
        }
        long available = this.cacheManager.getBytesAvailable() / 2L;
        long max = settings.getMaximumStorageForCleverCache();
        long toFree = Math.max(0L, settings.getMinimumSpaceForAd() - available);
        long size = Math.min(max, available);
        size = (long)((float)size - (float)size * this.cap);
        return Math.max(0L, size -= toFree);
    }
}

