/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.AdConfig;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.RuntimeValues;
import com.vungle.warren.ServiceLocator;
import com.vungle.warren.Vungle;
import com.vungle.warren.VungleBanner;
import com.vungle.warren.VungleSettings;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Placement;
import com.vungle.warren.persistence.Repository;

public final class Banners {
    private static final String TAG = Banners.class.getSimpleName();

    public static boolean canPlayAd(@NonNull String id, @NonNull AdConfig.AdSize adSize) {
        Context context = Vungle.appContext();
        if (context == null || !Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized");
            return false;
        }
        if (!AdConfig.AdSize.isBannerAdSize(adSize)) {
            Log.e((String)TAG, (String)"Invalid Ad Size. Cannot check loaded status of non banner size placements.");
            return false;
        }
        Advertisement advertisement = ServiceLocator.getInstance(context).getService(Repository.class).findValidAdvertisementForPlacement(id).get();
        Placement placement = ServiceLocator.getInstance(context).getService(Repository.class).load(id, Placement.class).get();
        if (placement == null) {
            return false;
        }
        AdConfig.AdSize adSizeOfLoadedAd = placement.getAdSize();
        if (adSize != adSizeOfLoadedAd) {
            return false;
        }
        if (advertisement == null || !advertisement.getAdConfig().getAdSize().equals((Object)adSize)) {
            return false;
        }
        return Vungle.canPlayAd(advertisement);
    }

    @Nullable
    public static VungleBanner getBanner(@NonNull String placementId, @NonNull AdConfig.AdSize adSize, @Nullable PlayAdCallback playAdCallback) {
        Context appContext = Vungle.appContext();
        if (appContext == null || !Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized, returned VungleNativeAd = null");
            Banners.onPlaybackError(placementId, playAdCallback, 9);
            return null;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(appContext);
        Repository repository = serviceLocator.getService(Repository.class);
        VungleSettings settings = ServiceLocator.getInstance((Context)appContext).getService(RuntimeValues.class).settings;
        if (TextUtils.isEmpty((CharSequence)placementId)) {
            Banners.onPlaybackError(placementId, playAdCallback, 13);
            return null;
        }
        Placement placement = repository.load(placementId, Placement.class).get();
        if (placement == null) {
            Banners.onPlaybackError(placementId, playAdCallback, 13);
            return null;
        }
        if (!AdConfig.AdSize.isBannerAdSize(adSize)) {
            Banners.onPlaybackError(placementId, playAdCallback, 30);
            return null;
        }
        if (!Banners.canPlayAd(placementId, adSize)) {
            Banners.onPlaybackError(placementId, playAdCallback, 10);
            return null;
        }
        if (settings != null && settings.getBannerRefreshDisabled()) {
            return new VungleBanner(appContext, placementId, 0, adSize, playAdCallback);
        }
        return new VungleBanner(appContext, placementId, placement.getAdRefreshDuration(), adSize, playAdCallback);
    }

    public static void loadBanner(final @NonNull String placementId, @NonNull AdConfig.AdSize adSize, final @Nullable LoadAdCallback callback) {
        Context appCtx = Vungle.appContext();
        if (appCtx == null || !Vungle.isInitialized()) {
            Banners.onLoadError(placementId, callback, 9);
            return;
        }
        if (adSize == null) {
            Banners.onLoadError(placementId, callback, 28);
            return;
        }
        final AdConfig adConfig = new AdConfig();
        adConfig.setAdSize(adSize);
        ServiceLocator.getInstance(appCtx).getService(Repository.class).load(placementId, Placement.class, new Repository.LoadCallback<Placement>(){

            @Override
            public void onLoaded(Placement result) {
                if (result == null) {
                    Banners.onLoadError(placementId, callback, 10);
                } else if (!AdConfig.AdSize.isBannerAdSize(adConfig.getAdSize())) {
                    Banners.onLoadError(placementId, callback, 30);
                } else {
                    Vungle.loadAdInternal(placementId, adConfig, callback);
                }
            }
        });
    }

    private static void onPlaybackError(@NonNull String placementId, @Nullable PlayAdCallback playAdCallback, @VungleException.ExceptionCode int code) {
        if (playAdCallback != null) {
            playAdCallback.onError(placementId, new VungleException(code));
        }
    }

    private static void onLoadError(@NonNull String id, @Nullable LoadAdCallback callback, @VungleException.ExceptionCode int code) {
        if (callback != null) {
            callback.onError(id, new VungleException(code));
        }
    }
}

