/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.vungle.warren.PresentationFactory;
import com.vungle.warren.ServiceLocator;
import com.vungle.warren.VungleStaticApi;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.ui.CloseDelegate;
import com.vungle.warren.ui.OrientationDelegate;
import com.vungle.warren.ui.contract.AdContract;
import com.vungle.warren.ui.state.BundleOptionsState;
import com.vungle.warren.ui.state.OptionsState;
import com.vungle.warren.ui.view.FullAdWidget;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AdActivity
extends Activity {
    public static final String PLACEMENT_EXTRA = "placement";
    private static final String TAG = "VungleActivity";
    public static final String PRESENTER_STATE = "presenter_state";
    private static AdContract.AdvertisementPresenter.EventListener bus;
    @Nullable
    private AdContract.AdvertisementPresenter presenter;
    private BroadcastReceiver broadcastReceiver;
    private String placementId;
    private PresentationFactory presenterFactory;
    private OptionsState state;
    private AtomicBoolean pendingStart = new AtomicBoolean(false);
    private PresentationFactory.FullScreenCallback fullscreenCallback = new PresentationFactory.FullScreenCallback(){

        @Override
        public void onResult(@Nullable Pair<AdContract.AdView, AdContract.AdvertisementPresenter> result, @Nullable VungleException error) {
            AdActivity.this.presenterFactory = null;
            if (result == null || error != null) {
                AdActivity.this.deliverError(10, AdActivity.this.placementId);
                AdActivity.this.finish();
                return;
            }
            AdActivity.this.presenter = (AdContract.AdvertisementPresenter)result.second;
            AdActivity.this.presenter.setEventListener(bus);
            AdContract.AdView adView = (AdContract.AdView)result.first;
            AdActivity.this.presenter.attach(adView, AdActivity.this.state);
            if (AdActivity.this.pendingStart.getAndSet(false)) {
                AdActivity.this.presenter.start();
            }
        }
    };

    public static void setEventListener(AdContract.AdvertisementPresenter.EventListener listener) {
        bus = listener;
    }

    @VisibleForTesting
    protected static AdContract.AdvertisementPresenter.EventListener getEventListener() {
        return bus;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        FullAdWidget fullAdWidget;
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(0x1000000, 0x1000000);
        this.placementId = this.getIntent().getStringExtra(PLACEMENT_EXTRA);
        ServiceLocator serviceLocator = ServiceLocator.getInstance((Context)this);
        VungleStaticApi vungleStaticApi = serviceLocator.getService(VungleStaticApi.class);
        if (!vungleStaticApi.isInitialized() || bus == null || TextUtils.isEmpty((CharSequence)this.placementId)) {
            this.finish();
            return;
        }
        try {
            fullAdWidget = new FullAdWidget((Context)this, this.getWindow());
        }
        catch (InstantiationException e) {
            this.deliverError(10, this.placementId);
            this.finish();
            return;
        }
        this.presenterFactory = serviceLocator.getService(PresentationFactory.class);
        this.state = savedInstanceState == null ? null : (OptionsState)savedInstanceState.getParcelable(PRESENTER_STATE);
        this.presenterFactory.getFullScreenPresentation((Context)this, this.placementId, fullAdWidget, this.state, new CloseDelegate(){

            @Override
            public void close() {
                AdActivity.this.finish();
            }
        }, new OrientationDelegate(){

            @Override
            public void setOrientation(int orientation) {
                AdActivity.this.setRequestedOrientation(orientation);
            }
        }, savedInstanceState, this.fullscreenCallback);
        this.setContentView((View)fullAdWidget, fullAdWidget.getLayoutParams());
        this.connectBroadcastReceiver();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        String oldPlacement = this.getIntent().getStringExtra(PLACEMENT_EXTRA);
        String newPlacement = intent.getStringExtra(PLACEMENT_EXTRA);
        if (oldPlacement != null && newPlacement != null && !oldPlacement.equals(newPlacement)) {
            Log.d((String)TAG, (String)("Tried to play another placement " + newPlacement + " while playing " + oldPlacement));
            this.deliverError(15, newPlacement);
        }
    }

    private void deliverError(int code, String placementId) {
        if (bus != null) {
            bus.onError(new VungleException(code), placementId);
        }
    }

    private void connectBroadcastReceiver() {
        this.broadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String command;
                switch (command = intent.getStringExtra("command")) {
                    case "closeFlex": {
                        String placementID = intent.getStringExtra(AdActivity.PLACEMENT_EXTRA);
                        if (AdActivity.this.presenter == null) break;
                        AdActivity.this.presenter.handleExit(placementID);
                        break;
                    }
                    case "stopAll": {
                        AdActivity.this.finish();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No such command " + command);
                    }
                }
            }
        };
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).registerReceiver(this.broadcastReceiver, new IntentFilter("AdvertisementBus"));
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus) {
            if (this.presenter != null) {
                this.presenter.start();
            } else {
                this.pendingStart.set(true);
            }
        } else {
            if (this.presenter != null) {
                int flag = (this.isChangingConfigurations() ? 1 : 0) | (this.isFinishing() ? 2 : 0);
                this.presenter.stop(flag);
            }
            this.pendingStart.set(false);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.orientation == 2) {
            Log.d((String)TAG, (String)"landscape");
        } else if (newConfig.orientation == 1) {
            Log.d((String)TAG, (String)"portrait");
        }
        if (this.presenter != null) {
            this.presenter.onViewConfigurationChanged();
        }
    }

    @SuppressLint(value={"ResourceType"})
    public void onBackPressed() {
        if (this.presenter != null) {
            this.presenter.handleExit(null);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        Log.d((String)TAG, (String)"onSaveInstanceState");
        BundleOptionsState optionsState = new BundleOptionsState();
        if (this.presenter != null) {
            this.presenter.generateSaveState(optionsState);
            outState.putParcelable(PRESENTER_STATE, (Parcelable)optionsState);
        }
        if (this.presenterFactory != null) {
            this.presenterFactory.saveState(outState);
        }
        super.onSaveInstanceState(outState);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        Log.d((String)TAG, (String)("onRestoreInstanceState(" + savedInstanceState + ")"));
        if (savedInstanceState != null && this.presenter != null) {
            this.presenter.restoreFromSave((OptionsState)savedInstanceState.getParcelable(PRESENTER_STATE));
        }
    }

    public void setRequestedOrientation(int requestedOrientation) {
        if (this.canRotate()) {
            super.setRequestedOrientation(requestedOrientation);
        }
    }

    protected abstract boolean canRotate();

    protected void onDestroy() {
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).unregisterReceiver(this.broadcastReceiver);
        if (this.presenter != null) {
            this.presenter.detach(this.isChangingConfigurations());
        } else if (this.presenterFactory != null) {
            this.presenterFactory.destroy();
            this.presenterFactory = null;
            if (bus != null) {
                bus.onError(new VungleException(25), this.placementId);
            }
        }
        System.gc();
        super.onDestroy();
    }
}

