/*
 * Decompiled with CFR 0.152.
 */
package com.vsa.seekbarindicated;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.vsa.seekbarindicated.R;

public class SeekBarIndicated
extends FrameLayout
implements SeekBar.OnSeekBarChangeListener {
    private ViewGroup mWrapperIndicator;
    private ImageView mImageViewIndicator;
    private TextView mTextViewProgress;
    private SeekBar mSeekBar;
    private RelativeLayout mWrapperSeekBarMaxMinValues;
    private TextView mTextViewMinValue;
    private TextView mTextViewMaxValue;
    private int mSeekBarMarginLeft = 0;
    private int mSeekBarMarginTop = 0;
    private int mSeekBarMarginBottom = 0;
    private int mSeekBarMarginRight = 0;
    private String mIndicatorText;
    private int mSeekBarMin = 0;
    private SeekBar.OnSeekBarChangeListener mOnSeekBarChangeListener;
    private TextProvider mTextProviderIndicator;
    private int mMeasuredWidth;

    public SeekBarIndicated(Context context) {
        super(context);
        if (!this.isInEditMode()) {
            this.init(context);
        }
    }

    public SeekBarIndicated(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!this.isInEditMode()) {
            this.init(context, attrs, 0);
        }
    }

    public SeekBarIndicated(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (!this.isInEditMode()) {
            this.init(context, attrs, defStyleAttr);
        }
    }

    private void init(Context context) {
        this.init(context, null, 0);
    }

    private void init(Context context, AttributeSet attrs, int defStyle) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.view_seekbar_indicated, (ViewGroup)this);
        this.bindViews(view);
        if (attrs != null) {
            this.setAttributes(context, attrs, defStyle);
        }
        this.mSeekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.mTextViewProgress.setText((CharSequence)String.valueOf(this.mSeekBar.getProgress()));
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                SeekBarIndicated.this.mMeasuredWidth = SeekBarIndicated.this.mSeekBar.getWidth() - SeekBarIndicated.this.mSeekBar.getPaddingLeft() - SeekBarIndicated.this.mSeekBar.getPaddingRight();
                SeekBarIndicated.this.mSeekBar.setPadding(SeekBarIndicated.this.mSeekBar.getPaddingLeft(), SeekBarIndicated.this.mSeekBar.getPaddingTop() + SeekBarIndicated.this.mWrapperIndicator.getHeight(), SeekBarIndicated.this.mSeekBar.getPaddingRight(), SeekBarIndicated.this.mSeekBar.getPaddingBottom());
                SeekBarIndicated.this.setIndicator();
                SeekBarIndicated.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    private void bindViews(View view) {
        this.mWrapperIndicator = (ViewGroup)view.findViewById(R.id.wrapper_seekbar_indicator);
        this.mImageViewIndicator = (ImageView)view.findViewById(R.id.img_seekbar_indicator);
        this.mTextViewProgress = (TextView)view.findViewById(R.id.txt_seekbar_indicated_progress);
        this.mSeekBar = (SeekBar)view.findViewById(R.id.seekbar);
        this.mWrapperSeekBarMaxMinValues = (RelativeLayout)view.findViewById(R.id.wrapper_seekbar_max_min_values);
        this.mTextViewMinValue = (TextView)view.findViewById(R.id.txt_seekbar_min_value);
        this.mTextViewMaxValue = (TextView)view.findViewById(R.id.txt_seekbar_max_value);
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        this.setIndicator();
        if (this.mOnSeekBarChangeListener != null) {
            this.mOnSeekBarChangeListener.onProgressChanged(seekBar, progress, fromUser);
        }
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        if (this.mOnSeekBarChangeListener != null) {
            this.mOnSeekBarChangeListener.onStartTrackingTouch(seekBar);
        }
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        if (this.mOnSeekBarChangeListener != null) {
            this.mOnSeekBarChangeListener.onStopTrackingTouch(seekBar);
        }
    }

    private void setIndicator() {
        if (this.mTextProviderIndicator != null) {
            this.mTextViewProgress.setText((CharSequence)this.mTextProviderIndicator.provideText(this.getProgress()));
        } else if (this.mIndicatorText != null) {
            try {
                this.mTextViewProgress.setText((CharSequence)String.valueOf(String.format(this.mIndicatorText, this.getProgress())));
            }
            catch (Exception e) {
                this.mTextViewProgress.setText((CharSequence)String.valueOf(this.getProgress()));
            }
        } else {
            this.mTextViewProgress.setText((CharSequence)String.valueOf(this.getProgress()));
        }
        Rect padding = new Rect();
        this.mSeekBar.getThumb().getPadding(padding);
        int thumbPos = this.mSeekBar.getPaddingLeft() + this.mMeasuredWidth * this.mSeekBar.getProgress() / this.mSeekBar.getMax();
        thumbPos = (int)Math.ceil(thumbPos);
        this.mWrapperIndicator.setX((float)(thumbPos - (int)Math.ceil(this.mWrapperIndicator.getWidth() / 2)));
    }

    private void setAttributes(Context context, AttributeSet attrs, int defStyle) {
        TypedArray arr = context.obtainStyledAttributes(attrs, R.styleable.SeekBarIndicated, defStyle, 0);
        this.mSeekBarMarginLeft = arr.getDimensionPixelSize(R.styleable.SeekBarIndicated_seekbar_marginLeft, 0);
        this.mSeekBarMarginTop = arr.getDimensionPixelSize(R.styleable.SeekBarIndicated_seekbar_marginTop, 0);
        this.mSeekBarMarginRight = arr.getDimensionPixelSize(R.styleable.SeekBarIndicated_seekbar_marginRight, 0);
        this.mSeekBarMarginBottom = arr.getDimensionPixelSize(R.styleable.SeekBarIndicated_seekbar_marginBottom, 0);
        this.mSeekBarMin = arr.getInt(R.styleable.SeekBarIndicated_seekbar_min, 0);
        int seekBarMax = arr.getInt(R.styleable.SeekBarIndicated_seekbar_max, 100);
        int seekBarThumbId = arr.getResourceId(R.styleable.SeekBarIndicated_seekbar_thumb, 0);
        int seekBarProgressDrawableId = arr.getResourceId(R.styleable.SeekBarIndicated_seekbar_progressDrawable, 0);
        int indicatorTextStyle = arr.getInt(R.styleable.SeekBarIndicated_indicator_textStyle, 0);
        int indicatorPaddingLeft = arr.getDimensionPixelSize(R.styleable.SeekBarIndicated_indicator_paddingLeft, 0);
        int indicatorPaddingTop = arr.getDimensionPixelSize(R.styleable.SeekBarIndicated_indicator_paddingTop, 0);
        int indicatorPaddingRight = arr.getDimensionPixelSize(R.styleable.SeekBarIndicated_indicator_paddingRight, 0);
        int indicatorPaddingBottom = arr.getDimensionPixelSize(R.styleable.SeekBarIndicated_indicator_paddingBottom, 0);
        this.mWrapperIndicator.setPadding(indicatorPaddingLeft, indicatorPaddingTop, indicatorPaddingRight, indicatorPaddingBottom);
        this.setMin(this.mSeekBarMin);
        this.setMax(seekBarMax);
        if (seekBarThumbId > 0) {
            if (Build.VERSION.SDK_INT < 21) {
                this.mSeekBar.setThumb(this.getResources().getDrawable(seekBarThumbId));
            } else {
                this.mSeekBar.setThumb(this.getResources().getDrawable(seekBarThumbId, null));
            }
        }
        if (seekBarProgressDrawableId > 0) {
            if (Build.VERSION.SDK_INT < 21) {
                this.mSeekBar.setProgressDrawable(this.getResources().getDrawable(seekBarProgressDrawableId));
            } else {
                this.mSeekBar.setProgressDrawable(this.getResources().getDrawable(seekBarProgressDrawableId, null));
            }
        }
        this.mIndicatorText = arr.getString(R.styleable.SeekBarIndicated_indicator_text);
        this.mTextViewProgress.setTypeface(this.mTextViewProgress.getTypeface(), indicatorTextStyle);
        this.mTextViewMinValue.setTypeface(this.mTextViewProgress.getTypeface(), indicatorTextStyle);
        this.mTextViewMaxValue.setTypeface(this.mTextViewProgress.getTypeface(), indicatorTextStyle);
        this.mWrapperSeekBarMaxMinValues.setPadding(this.mSeekBarMarginLeft + this.mSeekBar.getPaddingLeft(), 0, this.mSeekBarMarginRight + this.mSeekBar.getPaddingRight(), 0);
        this.mSeekBar.setPadding(this.mSeekBar.getPaddingLeft() + this.mSeekBarMarginLeft, this.mSeekBar.getPaddingTop() + this.mSeekBarMarginTop, this.mSeekBar.getPaddingRight() + this.mSeekBarMarginRight, this.mSeekBar.getPaddingBottom() + this.mSeekBarMarginBottom);
        this.setIndicatorImage(arr);
        this.setIndicatorTextAttributes(arr);
        arr.recycle();
    }

    private void setIndicatorTextAttributes(TypedArray arr) {
        boolean centerVertical;
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mTextViewProgress.getLayoutParams();
        int indicatorTextMarginLeft = arr.getDimensionPixelSize(R.styleable.SeekBarIndicated_indicator_textMarginLeft, layoutParams.leftMargin);
        int indicatorTextMarginTop = arr.getDimensionPixelSize(R.styleable.SeekBarIndicated_indicator_textMarginTop, this.getContext().getResources().getDimensionPixelSize(R.dimen.indicator_txt_margin_top));
        int indicatorTextMarginRight = arr.getDimensionPixelSize(R.styleable.SeekBarIndicated_indicator_textMarginRight, layoutParams.rightMargin);
        int indicatorTextMarginBottom = arr.getDimensionPixelSize(R.styleable.SeekBarIndicated_indicator_textMarginBottom, layoutParams.bottomMargin);
        int indicatorTextColor = arr.getColor(R.styleable.SeekBarIndicated_indicator_textColor, -1);
        if (arr.hasValue(R.styleable.SeekBarIndicated_indicator_textCenterHorizontal)) {
            boolean centerHorizontal = arr.getBoolean(R.styleable.SeekBarIndicated_indicator_textCenterHorizontal, false);
            if (centerHorizontal) {
                layoutParams.addRule(14);
                if (!arr.hasValue(R.styleable.SeekBarIndicated_indicator_textMarginTop)) {
                    indicatorTextMarginTop = 0;
                }
            }
        } else {
            layoutParams.addRule(14);
        }
        if (arr.hasValue(R.styleable.SeekBarIndicated_indicator_textCenterVertical) && (centerVertical = arr.getBoolean(R.styleable.SeekBarIndicated_indicator_textCenterVertical, false))) {
            layoutParams.addRule(15);
        }
        this.mTextViewProgress.setTextColor(indicatorTextColor);
        layoutParams.setMargins(indicatorTextMarginLeft, indicatorTextMarginTop, indicatorTextMarginBottom, indicatorTextMarginRight);
        this.mTextViewProgress.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void setIndicatorImage(TypedArray arr) {
        int imageResourceId = arr.getResourceId(R.styleable.SeekBarIndicated_indicator_src, R.drawable.indicator_icon);
        this.mImageViewIndicator.setImageResource(imageResourceId);
    }

    public void setMax(int max) {
        this.mSeekBar.setMax(max - this.mSeekBarMin);
        this.mTextViewMaxValue.setText((CharSequence)String.valueOf(max));
    }

    public void setMin(int min) {
        this.mSeekBarMin = min;
        this.mTextViewMinValue.setText((CharSequence)String.valueOf(min));
    }

    public void setOnSeekBarChangeListener(SeekBar.OnSeekBarChangeListener onSeekBarChangeListener) {
        this.mOnSeekBarChangeListener = onSeekBarChangeListener;
    }

    public void setTextProviderIndicator(TextProvider textProviderIndicator) {
        this.mTextProviderIndicator = textProviderIndicator;
    }

    public int getProgress() {
        int unsignedMin = this.mSeekBarMin < 0 ? this.mSeekBarMin * -1 : this.mSeekBarMin;
        return this.mSeekBar.getProgress() + unsignedMin;
    }

    public static interface TextProvider {
        public String provideText(int var1);
    }
}

