/*
 * Decompiled with CFR 0.152.
 */
package com.vsa.asm.lib;

import android.graphics.Canvas;
import android.view.animation.Interpolator;
import com.vsa.asm.lib.SlidingMenu;

public class CanvasTransformerBuilder {
    private SlidingMenu.CanvasTransformer mTrans;
    private static Interpolator lin = new Interpolator(){

        public float getInterpolation(float t) {
            return t;
        }
    };

    private void initTransformer() {
        if (this.mTrans == null) {
            this.mTrans = new SlidingMenu.CanvasTransformer(){

                @Override
                public void transformCanvas(Canvas canvas, float percentOpen) {
                }
            };
        }
    }

    public SlidingMenu.CanvasTransformer zoom(int openedX, int closedX, int openedY, int closedY, int px, int py) {
        return this.zoom(openedX, closedX, openedY, closedY, px, py, lin);
    }

    public SlidingMenu.CanvasTransformer zoom(final int openedX, final int closedX, final int openedY, final int closedY, final int px, final int py, final Interpolator interp) {
        this.initTransformer();
        this.mTrans = new SlidingMenu.CanvasTransformer(){

            @Override
            public void transformCanvas(Canvas canvas, float percentOpen) {
                CanvasTransformerBuilder.this.mTrans.transformCanvas(canvas, percentOpen);
                float f = interp.getInterpolation(percentOpen);
                canvas.scale((float)(openedX - closedX) * f + (float)closedX, (float)(openedY - closedY) * f + (float)closedY, (float)px, (float)py);
            }
        };
        return this.mTrans;
    }

    public SlidingMenu.CanvasTransformer rotate(int openedDeg, int closedDeg, int px, int py) {
        return this.rotate(openedDeg, closedDeg, px, py, lin);
    }

    public SlidingMenu.CanvasTransformer rotate(final int openedDeg, final int closedDeg, final int px, final int py, final Interpolator interp) {
        this.initTransformer();
        this.mTrans = new SlidingMenu.CanvasTransformer(){

            @Override
            public void transformCanvas(Canvas canvas, float percentOpen) {
                CanvasTransformerBuilder.this.mTrans.transformCanvas(canvas, percentOpen);
                float f = interp.getInterpolation(percentOpen);
                canvas.rotate((float)(openedDeg - closedDeg) * f + (float)closedDeg, (float)px, (float)py);
            }
        };
        return this.mTrans;
    }

    public SlidingMenu.CanvasTransformer translate(int openedX, int closedX, int openedY, int closedY) {
        return this.translate(openedX, closedX, openedY, closedY, lin);
    }

    public SlidingMenu.CanvasTransformer translate(final int openedX, final int closedX, final int openedY, final int closedY, final Interpolator interp) {
        this.initTransformer();
        this.mTrans = new SlidingMenu.CanvasTransformer(){

            @Override
            public void transformCanvas(Canvas canvas, float percentOpen) {
                CanvasTransformerBuilder.this.mTrans.transformCanvas(canvas, percentOpen);
                float f = interp.getInterpolation(percentOpen);
                canvas.translate((float)(openedX - closedX) * f + (float)closedX, (float)(openedY - closedY) * f + (float)closedY);
            }
        };
        return this.mTrans;
    }

    public SlidingMenu.CanvasTransformer concatTransformer(final SlidingMenu.CanvasTransformer t) {
        this.initTransformer();
        this.mTrans = new SlidingMenu.CanvasTransformer(){

            @Override
            public void transformCanvas(Canvas canvas, float percentOpen) {
                CanvasTransformerBuilder.this.mTrans.transformCanvas(canvas, percentOpen);
                t.transformCanvas(canvas, percentOpen);
            }
        };
        return this.mTrans;
    }
}

