/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.FrameLayout;
import com.voxeet.video.R;

public class RoundedFrameLayout
extends FrameLayout {
    private static final String TAG = RoundedFrameLayout.class.getSimpleName();
    private Path path = new Path();
    private RectF rect = new RectF();
    private boolean isCircle;
    private float cornerRadius;

    public RoundedFrameLayout(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public RoundedFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public RoundedFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @RequiresApi(api=21)
    public RoundedFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        TypedArray attributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.RoundedFrameLayout);
        this.isCircle = attributes.getBoolean(R.styleable.RoundedFrameLayout_roundedCircle, false);
        this.cornerRadius = attributes.getDimension(R.styleable.RoundedFrameLayout_roundedCornerRadius, 0.0f);
        attributes.recycle();
        Log.d((String)TAG, (String)("init: " + this.cornerRadius));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateSize(w, h);
    }

    protected void dispatchDraw(Canvas canvas) {
        int save = canvas.save();
        canvas.clipPath(this.path);
        super.dispatchDraw(canvas);
        canvas.restoreToCount(save);
    }

    public RoundedFrameLayout setIsCircle(boolean isCircle) {
        this.isCircle = isCircle;
        this.invalidatePath();
        return this;
    }

    public RoundedFrameLayout setCornerRadius(float cornerRadius) {
        this.cornerRadius = cornerRadius;
        this.invalidatePath();
        return this;
    }

    private void invalidatePath() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width > 0 && height > 0) {
            this.updateSize(width, height);
            this.postInvalidate();
        }
    }

    private void updateSize(int width, int height) {
        if (this.isCircle) {
            float halfWidth = (float)width / 2.0f;
            float halfHeight = (float)height / 2.0f;
            this.path.reset();
            this.path.addCircle(halfWidth, halfHeight, Math.min(halfWidth, halfHeight), Path.Direction.CW);
            this.path.close();
        } else {
            this.path.reset();
            float[] radii = new float[]{this.cornerRadius, this.cornerRadius, this.cornerRadius, this.cornerRadius, this.cornerRadius, this.cornerRadius, this.cornerRadius, this.cornerRadius};
            this.rect.set(0.0f, 0.0f, (float)width, (float)height);
            this.path.addRoundRect(this.rect, radii, Path.Direction.CW);
            this.path.close();
        }
    }
}

