package com.voxeet.sdk.views;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.android.media.MediaStream;

import org.webrtc.EglBase;
import org.webrtc.VideoSink;

public class ViewFactory {

    @Nullable
    private static MediaProvider provider;

    public static MediaProvider get() {
        return provider;
    }

    public static void set(@NonNull MediaProvider provider) {
        ViewFactory.provider = provider;
    }

    public interface MediaProvider {
        EglBase.Context getEglContext();

        boolean hasMedia();

        boolean attachMediaStream(MediaStream stream, VideoSink videoSink);

        void unAttachMediaStream(VideoSink videoSink);
    }

}
