/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.stats;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.voxeet.stats.AbstractStats;
import com.voxeet.stats.StatsBuilderFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LocalStats
extends AbstractStats<JSONArray> {
    private static final String TAG = LocalStats.class.getSimpleName();
    public String userId;
    private List<HashMap<String, Object>> jsonResult;
    private List<AbstractStats<JSONObject>> stats = new ArrayList<AbstractStats<JSONObject>>();

    private LocalStats() {
    }

    @Override
    @Nullable
    public String getType() {
        return "local-stats";
    }

    public LocalStats(@NonNull String userId) {
        this();
        this.userId = userId;
    }

    @NonNull
    public String getUserId() {
        return this.userId;
    }

    @Override
    @Nullable
    public JSONArray toJson() throws JSONException {
        try {
            return new JSONArray(this.getRawJson());
        }
        catch (Exception e) {
            return new JSONArray();
        }
    }

    @NonNull
    public <STATS> List<STATS> getStatsForClass(Class<STATS> klass) {
        ArrayList<AbstractStats<JSONObject>> list = new ArrayList<AbstractStats<JSONObject>>();
        for (AbstractStats<JSONObject> in_list : this.stats) {
            if (!klass.isAssignableFrom(in_list.getClass())) continue;
            list.add(in_list);
        }
        return list;
    }

    private static boolean isValid(@Nullable List<String> validTypes, @Nullable String type) {
        if (null == validTypes || validTypes.size() == 0) {
            return true;
        }
        for (String t : validTypes) {
            if (null == t || !t.equals(type)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.jsonResult = null;
        this.stats.clear();
    }

    public static String filterStats(String jsonArray, List<String> validTypes) {
        return LocalStats.filterStatsArray(jsonArray, validTypes).toString();
    }

    @NonNull
    public static JSONArray filterStatsArray(@Nullable String jsonArray, List<String> validTypes) {
        JSONArray output = new JSONArray();
        try {
            JSONArray array = new JSONArray(jsonArray);
            for (int i = 0; i < array.length(); ++i) {
                String type;
                JSONObject object = array.getJSONObject(i);
                String string = type = null != object && object.has("type") ? object.getString("type") : null;
                if (null == type || !LocalStats.isValid(validTypes, type)) continue;
                output.put((Object)object);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return output;
    }

    public void addStatFromGlobalJson(String jsonArray, List<String> validTypes) {
        this.setRawJson(jsonArray);
        try {
            this.jsonResult = (List)new ObjectMapper().readValue(jsonArray, ArrayList.class);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            JSONArray array = this.toJson();
            if (null != array) {
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject object = array.getJSONObject(i);
                    AbstractStats<JSONObject> stat = StatsBuilderFactory.parseObject(object);
                    if (null == stat || !LocalStats.isValid(validTypes, stat.getType())) continue;
                    this.stats.add(stat);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void addStatFromGlobalJson(String jsonArray) {
        this.addStatFromGlobalJson(jsonArray, null);
    }
}

