package com.voxeet.stats;

import android.support.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import org.json.JSONException;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown = true)
public class RTCRemoteInboundRTPStats extends AbstractStats<JSONObject> {

    public String type;
    public long ssrc;
    public String mediaType;
    public long packetLost;
    public long jitter;
    public long roundTimeTrip;
    public String localId;

    @Nullable
    @Override
    public String getType() {
        return type;
    }

    @Nullable
    @Override
    public JSONObject toJson() throws JSONException {
        return StatsBuilderFactory.toJsonObject(getRawJson());
    }
}
