package com.voxeet.stats;

import android.support.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import org.json.JSONException;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown = true)
public class RTCOutboundRTPStats extends AbstractStats<JSONObject> {
    public String type;
    public String id;
    public long timestamp;
    public long ssrc;
    public boolean isRemote;
    public String mediaType;
    public String trackId;
    public String transportId;
    public String codecId;
    public long packetsSent;
    public long bytesSent;

    @Nullable
    @Override
    public String getType() {
        return type;
    }

    @Nullable
    @Override
    public JSONObject toJson() throws JSONException {
        return StatsBuilderFactory.toJsonObject(getRawJson());
    }
}
