package com.voxeet.stats;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.fasterxml.jackson.databind.ObjectMapper;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LocalStats extends AbstractStats<JSONArray> {
    private static final String TAG = LocalStats.class.getSimpleName();
    public String userId;

    private List<HashMap<String, Object>> jsonResult;
    private List<AbstractStats<JSONObject>> stats;

    private LocalStats() {
        super();

        stats = new ArrayList<>();
    }

    @Nullable
    @Override
    public String getType() {
        return "local-stats";
    }

    public LocalStats(@NonNull String userId) {
        this();

        this.userId = userId;
    }

    @NonNull
    public String getUserId() {
        return userId;
    }

    @Nullable
    @Override
    public JSONArray toJson() throws JSONException {
        try {
            return new JSONArray(getRawJson());
        } catch (Exception e) {
            return new JSONArray();
        }
    }

    @NonNull
    public <STATS> List<STATS> getStatsForClass(Class<STATS> klass) {
        List<STATS> list = new ArrayList<>();
        for (AbstractStats<JSONObject> in_list : stats) {
            if (klass.isAssignableFrom(in_list.getClass())) list.add((STATS) in_list);
        }

        return list;
    }

    private static boolean isValid(@Nullable List<String> validTypes, @Nullable String type) {
        if (null == validTypes || validTypes.size() == 0) return true;
        for (String t : validTypes) {
            if (null != t && t.equals(type)) return true;
        }
        return false;
    }

    public void clear() {
        jsonResult = null;
        stats.clear();
    }

    public static String filterStats(String jsonArray, List<String> validTypes) {
        return filterStatsArray(jsonArray, validTypes).toString();
    }

    @NonNull
    public static JSONArray filterStatsArray(@Nullable String jsonArray, List<String> validTypes) {
        JSONArray output = new JSONArray();
        try {
            JSONArray array = new JSONArray(jsonArray);
            for (int i = 0; i < array.length(); i++) {
                JSONObject object = array.getJSONObject(i);

                String type = null != object && object.has("type") ? object.getString("type") : null;

                if (null != type && isValid(validTypes, type)) {
                    output.put(object);
                }
            }
        } catch (JSONException e) {

        }

        return output;
    }

    public void addStatFromGlobalJson(String jsonArray, List<String> validTypes) {
        setRawJson(jsonArray);
        //parse the dictionnary
        try {
            jsonResult = new ObjectMapper().readValue(jsonArray, ArrayList.class);
        } catch (IOException e) {
        }

        //parse the objects
        try {
            JSONArray array = toJson();
            if (null != array) {
                for (int i = 0; i < array.length(); i++) {
                    JSONObject object = array.getJSONObject(i);

                    AbstractStats<JSONObject> stat = StatsBuilderFactory.parseObject(object);
                    if (null != stat && isValid(validTypes, stat.getType())) {
                        stats.add(stat);
                    }
                }
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void addStatFromGlobalJson(String jsonArray) {
        addStatFromGlobalJson(jsonArray, null);
    }
}
