package com.voxeet.stats;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Field;
import java.util.Iterator;

@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonSubTypes({
        @JsonSubTypes.Type(name = StatsBuilderConstants.TRANSPORT, value = RTCTransportStats.class),
        @JsonSubTypes.Type(name = StatsBuilderConstants.MEDIASTREAM, value = RTCMediaStreamTrackStats.class),
        @JsonSubTypes.Type(name = StatsBuilderConstants.PEERCONNECTION, value = RTCPeerConnectionStats.class),
        @JsonSubTypes.Type(name = StatsBuilderConstants.OUTBOUNDRTP, value = RTCOutboundRTPStats.class),
        @JsonSubTypes.Type(name = StatsBuilderConstants.INBOUNDRTP, value = RTCInboundRTPStreamStats.class),
        @JsonSubTypes.Type(name = StatsBuilderConstants.STREAM, value = RTCStreamStats.class),
        @JsonSubTypes.Type(name = StatsBuilderConstants.CODEC, value = RTCCodecStats.class),
        @JsonSubTypes.Type(name = StatsBuilderConstants.CERTIFICATE, value = RTCCertificateStats.class),
        @JsonSubTypes.Type(name = StatsBuilderConstants.LOCAL_CANDIDATE, value = RTCLocalCandidateStats.class),
        @JsonSubTypes.Type(name = StatsBuilderConstants.REMOTE_CANDIDATE, value = RTCRemoteCandidateStats.class),
        @JsonSubTypes.Type(name = StatsBuilderConstants.CANDIDATE_PAIR, value = RTCCandidatePairStats.class),
        @JsonSubTypes.Type(name = StatsBuilderConstants.INBOUNDRTP, value = RTCCandidatePairStats.class),
        @JsonSubTypes.Type(name = StatsBuilderConstants.REMOTE_INBOUNDRTP, value = RTCRemoteInboundRTPStats.class),
})
public abstract class AbstractStats<JSONTYPE> {

    @Nullable
    private String rawJson = "{}";

    protected AbstractStats() {
        rawJson = null;
    }

    @Nullable
    public abstract String getType();

    protected void setRawJson(@NonNull String rawJson) {
        this.rawJson = rawJson;
    }

    @Nullable
    public String getRawJson() {
        if(null == rawJson) return "[]";
        return rawJson;
    }

    public void logForUnknownProperties() {
        try {
            String TAG = getClass().getSimpleName();
            JSONObject object = new JSONObject(getRawJson());

            Field[] fields = getClass().getFields();

            //check for property in the class which does not exists in the json
            for (Field field : fields) {
                if (!object.has(field.getName())) {
                    Log.d("AbstractStats", TAG + " logForUnknownProperties: object property does not exists in json := " + field.getName());
                }
            }

            //check for json key which does not exists in the object
            Iterator<String> keys = object.keys();
            while (keys.hasNext()) {
                String key = keys.next();
                boolean found = false;

                for (Field field : fields) {
                    if (field.getName().equals(key)) {
                        found = true;
                    }
                }
                if (!found) {
                    Log.d("AbstractStats", TAG + " logForUnknownProperties: json property does not exists in object := " + key);
                }
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public abstract JSONTYPE toJson() throws JSONException;
}
