package com.voxeet.stats;

import android.support.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class RTCStreamStats extends AbstractStats<JSONObject> {

    public String type;
    public String id;
    public long timestamp;
    public String streamIdentifier;
    public List<String> trackIds;

    @Nullable
    @Override
    public JSONObject toJson() throws JSONException {
        return StatsBuilderFactory.toJsonObject(getRawJson());
    }
}
