package com.voxeet.stats;

import android.support.annotation.Nullable;
import android.util.Log;

import com.fasterxml.jackson.databind.ObjectMapper;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;

public final class StatsBuilderFactory {

    private static final String TAG = StatsBuilderFactory.class.getSimpleName();
    private static ObjectMapper sMapper = new ObjectMapper();

    private StatsBuilderFactory() {

    }

    public static AbstractStats<JSONObject> parseObject(JSONObject object) {
        try {
            String string = object.toString();
            AbstractStats<JSONObject> result = sMapper.readValue(string, AbstractStats.class);

            if (null != result) {
                result.setRawJson(string);
                //result.logForUnknownProperties();
            }
            return result;
        } catch (IOException e) {
            Log.e(TAG, "failed to decode command", e);
            Log.d(TAG, "parseObject: unknown := " + object.toString());
        }
        return null;
    }

    @Nullable
    public static JSONArray toJsonArray(String rawJson) {
        try {
            return new JSONArray(rawJson);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    public static JSONObject toJsonObject(String rawJson) {
        try {
            return new JSONObject(rawJson);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }
}
