package com.voxeet.stats;

import android.support.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import org.json.JSONException;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown = true)
public class RTCMediaStreamTrackStats extends AbstractStats<JSONObject> {
    public String type;
    public String id;
    public long timestamp;
    public String trackIdentifier;
    public boolean remoteSource;
    public boolean ended;
    public boolean detached;
    public String kind;
    public double jitterBufferDelay;
    public double audioLevel;
    public double totalAudioEnergy;
    public double totalSamplesDuration;
    public long concealedSamples;
    public long concealmentEvents;

    public long frameWidth;
    public long frameHeight;
    public double framesPerSecond;
    public long framesSent;
    public long framesReceived;
    public long framesDecoded;
    public long framesDropped;
    public long framesCorrupted;
    public long partialFramesLost;
    public long fullFramesLost;
    public double echoReturnLoss;
    public double echoReturnLossEnhancement;

    public RTCMediaStreamTrackStats() {

    }

    @Nullable
    @Override
    public JSONObject toJson() throws JSONException {
        return StatsBuilderFactory.toJsonObject(getRawJson());
    }


    @Override
    public String toString() {
        return id + " " + timestamp + " " + " " + getRawJson();
    }
}
