/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.push.center.invitation;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.models.ParticipantNotification;
import com.voxeet.sdk.models.v1.ConferenceParticipantStatus;
import com.voxeet.sdk.push.utils.Annotate;
import com.voxeet.sdk.utils.Opt;
import java.util.HashMap;
import java.util.Map;

@Annotate
public class InvitationBundle {
    @NonNull
    public ParticipantNotification inviter;
    @Nullable
    public String conferenceId;

    public InvitationBundle(@Nullable String inviterId, @Nullable String inviterName, @Nullable String inviterExternalId, @Nullable String conferenceId, @Nullable String inviterAvatarUrl) {
        this.conferenceId = conferenceId;
        this.inviter = new ParticipantNotification((String)Opt.of((Object)inviterId).or((Object)""), new ParticipantInfo((String)Opt.of((Object)inviterName).orNull(), (String)Opt.of((Object)inviterExternalId).orNull(), (String)Opt.of((Object)inviterAvatarUrl).orNull()), ConferenceParticipantStatus.UNKNWON);
    }

    public InvitationBundle(@NonNull Bundle bundle) {
        this(bundle.getString("UserId", null), bundle.getString("DisplayName", null), bundle.getString("ExternalId", null), bundle.getString("ConfId", null), bundle.getString("AvatarUrl", null));
    }

    public InvitationBundle(@NonNull Map<String, String> remoteMessage) {
        this(InvitationBundle.get(remoteMessage, "UserId"), InvitationBundle.get(remoteMessage, "DisplayName"), InvitationBundle.get(remoteMessage, "ExternalId"), InvitationBundle.get(remoteMessage, "ConfId"), InvitationBundle.get(remoteMessage, "AvatarUrl"));
    }

    @Nullable
    private static String get(@NonNull Map<String, String> map, @NonNull String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    @NonNull
    public Map<String, String> asMap() {
        String inviterId = this.inviter.getId();
        String inviterExternalId = (String)Opt.of((Object)this.inviter.getInfo()).then(ParticipantInfo::getExternalId).orNull();
        String inviterName = (String)Opt.of((Object)this.inviter.getInfo()).then(ParticipantInfo::getName).orNull();
        String inviterAvatarUrl = (String)Opt.of((Object)this.inviter.getInfo()).then(ParticipantInfo::getAvatarUrl).orNull();
        HashMap<String, String> map = new HashMap<String, String>();
        if (null != this.conferenceId) {
            map.put("ConfId", this.conferenceId);
        }
        if (null != inviterExternalId) {
            map.put("ExternalId", inviterExternalId);
        }
        if (null != inviterId) {
            map.put("UserId", inviterId);
        }
        if (null != inviterName) {
            map.put("DisplayName", inviterName);
        }
        if (null != inviterAvatarUrl) {
            map.put("AvatarUrl", inviterAvatarUrl);
        }
        return map;
    }

    @NonNull
    public Bundle asBundle() {
        Bundle bundle = new Bundle();
        bundle.putString("ConfId", this.conferenceId);
        bundle.putString("UserId", this.inviter.getId());
        bundle.putString("ExternalId", (String)Opt.of((Object)this.inviter.getInfo()).then(ParticipantInfo::getExternalId).orNull());
        bundle.putString("DisplayName", (String)Opt.of((Object)this.inviter.getInfo()).then(ParticipantInfo::getName).orNull());
        bundle.putString("AvatarUrl", (String)Opt.of((Object)this.inviter.getInfo()).then(ParticipantInfo::getAvatarUrl).orNull());
        return bundle;
    }
}

