/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.push.center;

import android.support.annotation.NonNull;
import android.util.Log;
import com.voxeet.sdk.push.center.subscription.event.ConferenceCreatedNotificationEvent;
import com.voxeet.sdk.push.center.subscription.event.ConferenceEndedNotificationEvent;
import com.voxeet.sdk.push.center.subscription.event.InvitationReceivedNotificationEvent;
import com.voxeet.sdk.push.center.subscription.event.ParticipantJoinedNotificationEvent;
import com.voxeet.sdk.push.center.subscription.event.ParticipantLeftNotificationEvent;
import com.voxeet.sdk.push.center.subscription.register.BaseSubscription;
import com.voxeet.sdk.push.center.subscription.register.SubscribeConferenceCreated;
import com.voxeet.sdk.push.center.subscription.register.SubscribeConferenceEnded;
import com.voxeet.sdk.push.center.subscription.register.SubscribeInvitation;
import com.voxeet.sdk.push.center.subscription.register.SubscribeParticipantJoined;
import com.voxeet.sdk.push.center.subscription.register.SubscribeParticipantLeft;
import com.voxeet.sdk.utils.Opt;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.greenrobot.eventbus.EventBus;

public class SubscriptionCenter {
    private static final String TAG = SubscriptionCenter.class.getSimpleName();
    private HashMap<Class<? extends BaseSubscription>, Call> subscribe_call = new HashMap();
    private HashMap<Class<? extends BaseSubscription>, Call> unsubscribe_call = new HashMap();
    private HashMap<Class<? extends BaseSubscription>, CopyOnWriteArrayList<String>> subscribed_maps = new HashMap();
    public static final SubscriptionCenter instance = new SubscriptionCenter();
    private boolean subscribe_invitations = true;

    private SubscriptionCenter() {
        this.subscribe_call.put(SubscribeConferenceCreated.class, o -> this.apply_sub((BaseSubscription)o, o.conferenceAlias));
        this.subscribe_call.put(SubscribeConferenceEnded.class, o -> this.apply_sub((BaseSubscription)o, o.conferenceAlias));
        this.subscribe_call.put(SubscribeParticipantJoined.class, o -> this.apply_sub((BaseSubscription)o, o.conferenceAlias));
        this.subscribe_call.put(SubscribeParticipantLeft.class, o -> this.apply_sub((BaseSubscription)o, o.conferenceAlias));
        this.subscribe_call.put(SubscribeInvitation.class, o -> {
            this.subscribe_invitations = true;
        });
        this.unsubscribe_call.put(SubscribeConferenceCreated.class, o -> this.apply_unsub((BaseSubscription)o, o.conferenceAlias));
        this.unsubscribe_call.put(SubscribeConferenceEnded.class, o -> this.apply_unsub((BaseSubscription)o, o.conferenceAlias));
        this.unsubscribe_call.put(SubscribeParticipantJoined.class, o -> this.apply_unsub((BaseSubscription)o, o.conferenceAlias));
        this.unsubscribe_call.put(SubscribeParticipantLeft.class, o -> this.apply_unsub((BaseSubscription)o, o.conferenceAlias));
        this.unsubscribe_call.put(SubscribeInvitation.class, o -> {
            this.subscribe_invitations = false;
        });
    }

    private void apply_sub(BaseSubscription o, String filter) {
        CopyOnWriteArrayList<String> map = this.subscribed_maps.get(o.getClass());
        if (null == map) {
            map = new CopyOnWriteArrayList();
            this.subscribed_maps.put(o.getClass(), map);
        }
        if (!map.contains(filter)) {
            map.add(filter);
        }
    }

    private void apply_unsub(BaseSubscription o, String filter) {
        CopyOnWriteArrayList<String> map = this.subscribed_maps.get(o.getClass());
        if (null == map) {
            map = new CopyOnWriteArrayList();
            this.subscribed_maps.put(o.getClass(), map);
        }
        map.remove(filter);
    }

    public void onEvent(@NonNull ConferenceCreatedNotificationEvent event) {
        Opt def = Opt.of(this.subscribed_maps.get(SubscribeConferenceCreated.class));
        if (((Boolean)def.then(m -> m.contains(event.conferenceAlias)).or((Object)false)).booleanValue()) {
            EventBus.getDefault().post((Object)event);
        }
    }

    public void onEvent(@NonNull ConferenceEndedNotificationEvent event) {
        Opt def = Opt.of(this.subscribed_maps.get(SubscribeConferenceEnded.class));
        if (((Boolean)def.then(m -> m.contains(event.conferenceAlias)).or((Object)false)).booleanValue()) {
            EventBus.getDefault().post((Object)event);
        }
    }

    public void onEvent(@NonNull ParticipantJoinedNotificationEvent event) {
        Opt def = Opt.of(this.subscribed_maps.get(SubscribeParticipantJoined.class));
        if (((Boolean)def.then(m -> m.contains(event.conferenceAlias)).or((Object)false)).booleanValue()) {
            EventBus.getDefault().post((Object)event);
        }
    }

    public void onEvent(@NonNull ParticipantLeftNotificationEvent event) {
        Opt def = Opt.of(this.subscribed_maps.get(SubscribeParticipantLeft.class));
        if (((Boolean)def.then(m -> m.contains(event.conferenceAlias)).or((Object)false)).booleanValue()) {
            EventBus.getDefault().post((Object)event);
        }
    }

    public void onEvent(@NonNull InvitationReceivedNotificationEvent event) {
        if (this.subscribe_invitations) {
            EventBus.getDefault().post((Object)event);
        } else {
            Log.d((String)TAG, (String)"onEvent: Invitation Received forward canceled : not subscribe_invitations flag");
        }
    }

    public void subscribe(@NonNull BaseSubscription subscribe) {
        Call call = this.subscribe_call.get(subscribe.getClass());
        if (null != call) {
            call.call(subscribe);
        }
    }

    public void unsubscribe(@NonNull BaseSubscription subscribe) {
        Call call = this.unsubscribe_call.get(subscribe.getClass());
        if (null != call) {
            call.call(subscribe);
        }
    }

    private static interface Call<PARAM> {
        public void call(PARAM var1);
    }
}

