/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.push.center;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.voxeet.sdk.push.center.invitation.IIncomingInvitationListener;
import com.voxeet.sdk.push.center.invitation.InvitationBundle;
import com.voxeet.sdk.push.center.management.EnforcedNotificationMode;
import com.voxeet.sdk.push.center.management.NotificationMode;
import com.voxeet.sdk.push.center.management.PushConferenceDestroyed;
import com.voxeet.sdk.push.center.management.VersionFilter;
import com.voxeet.sdk.push.center.subscription.event.ConferenceEndedNotificationEvent;
import com.voxeet.sdk.push.center.subscription.event.InvitationReceivedNotificationEvent;
import com.voxeet.sdk.push.utils.Annotate;
import com.voxeet.sdk.utils.Opt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

@Annotate
public class NotificationCenter {
    private static final String TAG = NotificationCenter.class.getSimpleName();
    public static NotificationCenter instance = new NotificationCenter();
    private Map<NotificationMode, Holder> invitationProviderForModes = new HashMap<NotificationMode, Holder>();
    @NonNull
    private EnforcedNotificationMode enforcedNotificationMode = EnforcedNotificationMode.FULLSCREEN_INCOMING_CALL;
    @Nullable
    private Context context;
    @NonNull
    private ReceiveSpecificEvents events = new ReceiveSpecificEvents();

    private NotificationCenter() {
        this.invitationProviderForModes.put(NotificationMode.NONE, new Holder());
    }

    public void init(@NonNull EventBus eventBus, @NonNull Context context) {
        this.context = context;
        if (!eventBus.isRegistered((Object)eventBus)) {
            eventBus.register((Object)this.events);
        }
    }

    public NotificationCenter setEnforcedNotificationMode(@NonNull EnforcedNotificationMode enforcedNotificationMode) {
        this.enforcedNotificationMode = enforcedNotificationMode;
        return this;
    }

    public NotificationCenter register(@NonNull NotificationMode notificationMode, @Nullable IIncomingInvitationListener invitationProvider) {
        Holder holder = this.invitationProviderForModes.get((Object)notificationMode);
        if (holder == null) {
            holder = new Holder();
            this.invitationProviderForModes.put(notificationMode, holder);
        }
        holder.invitationHolder = invitationProvider;
        return this;
    }

    public NotificationCenter register(@NonNull NotificationMode notificationMode, @NonNull VersionFilter filter) {
        Holder holder = this.invitationProviderForModes.get((Object)notificationMode);
        if (holder == null) {
            holder = new Holder();
            this.invitationProviderForModes.put(notificationMode, holder);
        }
        if (!holder.filters.contains(filter)) {
            holder.filters.add(filter);
        }
        return this;
    }

    public void onInvitationReceived(@NonNull Context context, @NonNull InvitationBundle invitationBundle) {
        this.onInvitationReceived(context, invitationBundle.asMap());
    }

    @NonNull
    public String onInvitationCanceledReceived(@NonNull Context context, @NonNull String conferenceId) {
        IIncomingInvitationListener listener = this.getIncomingInvitation();
        if (null != listener) {
            listener.onInvitationCanceled(context, conferenceId);
        }
        return conferenceId;
    }

    private void onInvitationReceived(@NonNull Context context, @NonNull Map<String, String> remoteMessage) {
        IIncomingInvitationListener listener = this.getIncomingInvitation();
        if (null != listener) {
            InvitationBundle invitationBundle = new InvitationBundle(remoteMessage);
            listener.onInvitation(context, invitationBundle);
        }
    }

    boolean manageRemoteMessage(@NonNull Context context, @NonNull Map<String, String> remoteMessage) {
        if (remoteMessage.containsKey("NotifType")) {
            String notificationType = remoteMessage.get("NotifType");
            if (null == notificationType || TextUtils.isEmpty((CharSequence)notificationType)) {
                notificationType = "";
            }
            switch (notificationType) {
                case "1": {
                    this.onInvitationReceived(context, remoteMessage);
                    break;
                }
                case "5": {
                    String conferenceId = (String)Opt.of((Object)new InvitationBundle(remoteMessage)).then(c -> c.conferenceId).or((Object)"");
                    conferenceId = this.onInvitationCanceledReceived(context, conferenceId);
                    EventBus.getDefault().post((Object)new PushConferenceDestroyed(conferenceId));
                    break;
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    private IIncomingInvitationListener getIncomingInvitation() {
        for (NotificationMode notificationMode : this.enforcedNotificationMode.getModes()) {
            Holder holder = this.invitationProviderForModes.get((Object)notificationMode);
            if (null == holder || holder.mustFilter(Build.MANUFACTURER, Build.VERSION.SDK_INT)) continue;
            return holder.invitationHolder;
        }
        return null;
    }

    public class ReceiveSpecificEvents {
        @Subscribe(threadMode=ThreadMode.MAIN)
        public void onEvent(@NonNull ConferenceEndedNotificationEvent event) {
            NotificationCenter.this.onInvitationCanceledReceived(NotificationCenter.this.context, event.conferenceId);
        }

        @Subscribe(threadMode=ThreadMode.MAIN)
        public void onEvent(@NonNull InvitationReceivedNotificationEvent event) {
            NotificationCenter.this.onInvitationReceived(NotificationCenter.this.context, event.invitation);
        }
    }

    private class Holder {
        @Nullable
        IIncomingInvitationListener invitationHolder;
        @NonNull
        public List<VersionFilter> filters = new CopyOnWriteArrayList<VersionFilter>();

        private Holder() {
        }

        public boolean mustFilter(@NonNull String manufacturer, int systemAPIVersion) {
            for (VersionFilter filter : this.filters) {
                if (!filter.mustFilter(manufacturer, systemAPIVersion)) continue;
                return true;
            }
            return false;
        }
    }
}

