package com.voxeet.sdk.push.center.subscription.register;

import android.support.annotation.NonNull;

import com.voxeet.sdk.push.center.subscription.Subscription;
import com.voxeet.sdk.push.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Represent a request to be notified about participant leaving a conference
 */
@Annotate
public class SubscribeParticipantLeft extends BaseSubscription {

    @NoDocumentation
    @NonNull
    public String conferenceAlias;

    private SubscribeParticipantLeft() {
        super(Subscription.ParticipantLeft, true);
    }

    /**
     * Construct a request with a specified conference alias.
     *
     * @param conferenceAlias conference alias.
     */
    public SubscribeParticipantLeft(@NonNull String conferenceAlias) {
        this();
        this.conferenceAlias = conferenceAlias;
    }

    @NoDocumentation
    @Override
    public String toString() {
        return "SubscribeParticipantLeft{" +
                "conferenceAlias='" + conferenceAlias + '\'' +
                ", type='" + type + '\'' +
                '}';
    }
}
