package com.voxeet.sdk.push.center.subscription.register;

import android.support.annotation.NonNull;

import com.voxeet.sdk.push.center.subscription.Subscription;
import com.voxeet.sdk.push.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Represent a request to be notified about a conference being terminated
 */
@Annotate
public class SubscribeConferenceEnded extends BaseSubscription {

    @NoDocumentation
    @NonNull
    public String conferenceAlias;

    private SubscribeConferenceEnded() {
        super(Subscription.Ended, true);
    }


    /**
     * Construct a request with a specified conference alias.
     *
     * @param conferenceAlias conference alias.
     */
    public SubscribeConferenceEnded(@NonNull String conferenceAlias) {
        this();
        this.conferenceAlias = conferenceAlias;
    }

    @NoDocumentation
    @Override
    public String toString() {
        return "SubscribeConferenceEnded{" +
                "conferenceAlias='" + conferenceAlias + '\'' +
                ", type='" + type + '\'' +
                '}';
    }
}
