package com.voxeet.sdk.push.center.subscription.register;

import android.support.annotation.NonNull;

import com.voxeet.sdk.push.center.subscription.Subscription;
import com.voxeet.sdk.push.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Represent a request to be notified about a conference being created
 */
@Annotate
public class SubscribeConferenceCreated extends BaseSubscription {

    @NoDocumentation
    @NonNull
    public String conferenceAlias;

    private SubscribeConferenceCreated() {
        super(Subscription.Created, true);
    }


    /**
     * Construct a request with a specified conference alias.
     *
     * @param conferenceAlias conference alias.
     */
    public SubscribeConferenceCreated(@NonNull String conferenceAlias) {
        this();
        this.conferenceAlias = conferenceAlias;
    }

    @NoDocumentation
    @Override
    public String toString() {
        return "SubscribeConferenceCreated{" +
                "conferenceAlias='" + conferenceAlias + '\'' +
                ", type='" + type + '\'' +
                '}';
    }
}
