package com.voxeet.sdk.push.center.subscription.register;

import android.support.annotation.NonNull;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.voxeet.sdk.push.center.subscription.Subscription;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * The Subscriptions can be :
 *<p>
 * - [SubscribeConferenceCreated](/documentation/sdk/reference/android/models/subscribeConferencecreated)
 *<p>
 * - [SubscribeConferenceEnded](/documentation/sdk/reference/android/models/subscribeconferenceended)
 *<p>
 * - [SubscribeInvitation](/documentation/sdk/reference/android/models/subscribeinvitation)
 *<p>
 * - [SubscribeParticipantJoined](/documentation/sdk/reference/android/models/subscribeparticipantjoined)
 *<p>
 * - [SubscribeParticipantLeft](/documentation/sdk/reference/android/models/subscribeparticipantleft)
 */
@Annotate
public class BaseSubscription {

    @NoDocumentation
    public String type;

    private boolean network = false;

    private BaseSubscription() {
        network = false;
    }

    BaseSubscription(@NonNull Subscription subscription, boolean network) {
        this();
        this.network = network;
        this.type = subscription.type;
    }

    @NoDocumentation
    @JsonIgnore
    public final boolean isNetworkCall() {
        return network;
    }
}
