package com.voxeet.sdk.push.center.subscription.register;

import android.support.annotation.NonNull;

import com.voxeet.sdk.push.center.subscription.Subscription;
import com.voxeet.sdk.push.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Represent a request to be notified about participant joining a conference
 */
@Annotate
public class SubscribeParticipantJoined extends BaseSubscription {

    @NoDocumentation
    @NonNull
    public String conferenceAlias;

    private SubscribeParticipantJoined() {
        super(Subscription.ParticipantJoined, true);
    }

    /**
     * Construct a request with a specified conference alias.
     *
     * @param conferenceAlias conference alias.
     */
    public SubscribeParticipantJoined(@NonNull String conferenceAlias) {
        this();
        this.conferenceAlias = conferenceAlias;
    }

    @NoDocumentation
    @Override
    public String toString() {
        return "SubscribeParticipantJoined{" +
                "conferenceAlias='" + conferenceAlias + '\'' +
                ", type='" + type + '\'' +
                '}';
    }
}
