package com.voxeet.sdk.push.center.subscription.event;

import android.support.annotation.NonNull;

import com.voxeet.sdk.models.ParticipantNotification;
import com.voxeet.sdk.push.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * The ParticipantLeftNotificationEvent model gathers information about participants who left a conference and uses it in notifications.
 */
@Annotate
public class ParticipantLeftNotificationEvent implements BaseNotificationEvent {

    /**
     * The conference ID
     */
    @NonNull
    public final String conferenceId;

    /**
     * The conference alias
     */
    @NonNull
    public final String conferenceAlias;

    /**
     * The participant who left
     */
    @NonNull
    public final ParticipantNotification participant;

    @NoDocumentation
    public ParticipantLeftNotificationEvent(@NonNull String conferenceId,
                                            @NonNull String conferenceAlias,
                                            @NonNull ParticipantNotification participant) {
        this.conferenceId = conferenceId;
        this.conferenceAlias = conferenceAlias;
        this.participant = participant;
    }

    @NoDocumentation
    @Override
    public String toString() {
        return "ParticipantLeftNotificationEvent{" +
                "conferenceId='" + conferenceId + '\'' +
                ", conferenceAlias='" + conferenceAlias + '\'' +
                ", participant='" + participant + '\'' +
                '}';
    }
}
