package com.voxeet.sdk.push.center.subscription.event;

import android.support.annotation.NonNull;

import com.voxeet.sdk.models.ParticipantNotification;
import com.voxeet.sdk.push.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * The ParticipantJoinedNotificationEvent model gathers information about participants who joined a conference and uses it in notifications.
 */
@Annotate
public class ParticipantJoinedNotificationEvent implements BaseNotificationEvent {

    /**
     * The conference ID
     */
    @NonNull
    public final String conferenceId;

    /**
     * The conference alias
     */
    @NonNull
    public final String conferenceAlias;

    /**
     * The participant who joined
     */
    @NonNull
    public final ParticipantNotification participant;

    @NoDocumentation
    @Override
    public String toString() {
        return "ParticipantJoinedNotificationEvent{" +
                "conferenceId='" + conferenceId + '\'' +
                ", conferenceAlias='" + conferenceAlias + '\'' +
                ", participant='" + participant + '\'' +
                '}';
    }

    @NoDocumentation
    public ParticipantJoinedNotificationEvent(@NonNull String conferenceId,
                                              @NonNull String conferenceAlias,
                                              @NonNull ParticipantNotification participant) {
        this.conferenceId = conferenceId;
        this.conferenceAlias = conferenceAlias;
        this.participant = participant;
    }
}
