package com.voxeet.sdk.push.center.subscription.event;

import android.support.annotation.NonNull;

import com.voxeet.sdk.push.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * The ConferenceEndedNotificationEvent model gathers information about an ended conference and uses it in notifications.
 */
@Annotate
public class ConferenceEndedNotificationEvent implements BaseNotificationEvent {

    /**
     * The conference ID
     */
    @NonNull
    public final String conferenceId;

    /**
     * The conference alias
     */
    @NonNull
    public final String conferenceAlias;

    @NoDocumentation
    @Override
    public String toString() {
        return "ConferenceEndedNotificationEvent{" +
                "conferenceId='" + conferenceId + '\'' +
                ", conferenceAlias='" + conferenceAlias + '\'' +
                '}';
    }

    @NoDocumentation
    public ConferenceEndedNotificationEvent(@NonNull String conferenceId, @NonNull String conferenceAlias) {
        this.conferenceId = conferenceId;
        this.conferenceAlias = conferenceAlias;
    }

}
