package com.voxeet.sdk.push.center.subscription.event;

import android.support.annotation.NonNull;

import com.voxeet.sdk.push.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * The ConferenceCreatedNotificationEvent model gathers information about a created conference and uses it in notifications.
 */
@Annotate
public class ConferenceCreatedNotificationEvent implements BaseNotificationEvent {

    /**
     * The conference ID
     */
    @NonNull
    public final String conferenceId;

    /**
     * The conference alias
     */
    @NonNull
    public final String conferenceAlias;

    @NoDocumentation
    public ConferenceCreatedNotificationEvent(@NonNull String conferenceId, @NonNull String conferenceAlias) {
        this.conferenceId = conferenceId;
        this.conferenceAlias = conferenceAlias;
    }

    @NoDocumentation
    @Override
    public String toString() {
        return "ConferenceCreatedNotificationEvent{" +
                "conferenceId='" + conferenceId + '\'' +
                ", conferenceAlias='" + conferenceAlias + '\'' +
                '}';
    }
}
