package com.voxeet.sdk.push.center.management;

import com.voxeet.sdk.push.utils.Annotate;
import com.voxeet.sdk.push.utils.NoDocumentation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * The EnforcedNotificationMode model establishes enforced modifications that are hard to ignore:
 * - Incoming calls are always visible as a fullscreen pop-up.
 * - Incoming calls are always visible as a simple notification.
 * - Incoming calls are visible as fullscreen pop-ups and fallback to the notification in case of the first fail.
 *
 * Use the `NotificationCenter.instance.setEnforcedNotificationMode(EnforcedNotificationMode.TheModeToUse)`.
 */
@Annotate
public enum EnforcedNotificationMode {
    NONE(NotificationMode.NONE),
    FULLSCREEN_INCOMING_CALL(NotificationMode.FULLSCREEN_INCOMING_CALL),
    OVERHEAD_INCOMING_CALL(NotificationMode.OVERHEAD_INCOMING_CALL),
    MIXED_INCOMING_CALL(NotificationMode.FULLSCREEN_INCOMING_CALL, NotificationMode.OVERHEAD_INCOMING_CALL);


    private List<NotificationMode> modes = new ArrayList<>();

    @NoDocumentation
    EnforcedNotificationMode(NotificationMode... modes) {
        this.modes.addAll(Arrays.asList(modes));
    }

    @NoDocumentation
    public List<NotificationMode> getModes() {
        return modes;
    }
}
