package com.voxeet.sdk.push.center;

import android.support.annotation.NonNull;
import android.util.Log;

import com.voxeet.sdk.push.center.subscription.event.ConferenceCreatedNotificationEvent;
import com.voxeet.sdk.push.center.subscription.event.ConferenceEndedNotificationEvent;
import com.voxeet.sdk.push.center.subscription.event.InvitationReceivedNotificationEvent;
import com.voxeet.sdk.push.center.subscription.event.ParticipantJoinedNotificationEvent;
import com.voxeet.sdk.push.center.subscription.event.ParticipantLeftNotificationEvent;
import com.voxeet.sdk.push.center.subscription.register.BaseSubscription;
import com.voxeet.sdk.push.center.subscription.register.SubscribeConferenceCreated;
import com.voxeet.sdk.push.center.subscription.register.SubscribeConferenceEnded;
import com.voxeet.sdk.push.center.subscription.register.SubscribeInvitation;
import com.voxeet.sdk.push.center.subscription.register.SubscribeParticipantJoined;
import com.voxeet.sdk.push.center.subscription.register.SubscribeParticipantLeft;
import com.voxeet.sdk.utils.Opt;

import org.greenrobot.eventbus.EventBus;

import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class SubscriptionCenter {
    private static final String TAG = SubscriptionCenter.class.getSimpleName();
    private HashMap<Class<? extends BaseSubscription>, Call> subscribe_call = new HashMap<>();
    private HashMap<Class<? extends BaseSubscription>, Call> unsubscribe_call = new HashMap<>();

    private HashMap<Class<? extends BaseSubscription>, CopyOnWriteArrayList<String>> subscribed_maps = new HashMap<>();

    public final static SubscriptionCenter instance = new SubscriptionCenter();
    private boolean subscribe_invitations = false;

    private SubscriptionCenter() {
        subscribe_call.put(SubscribeConferenceCreated.class, (Call<SubscribeConferenceCreated>) o -> apply_sub(o, o.conferenceAlias));
        subscribe_call.put(SubscribeConferenceEnded.class, (Call<SubscribeConferenceEnded>) o -> apply_sub(o, o.conferenceAlias));
        subscribe_call.put(SubscribeParticipantJoined.class, (Call<SubscribeParticipantJoined>) o -> apply_sub(o, o.conferenceAlias));
        subscribe_call.put(SubscribeParticipantLeft.class, (Call<SubscribeParticipantLeft>) o -> apply_sub(o, o.conferenceAlias));
        subscribe_call.put(SubscribeInvitation.class, (Call<SubscribeInvitation>) o -> subscribe_invitations = true);

        unsubscribe_call.put(SubscribeConferenceCreated.class, (Call<SubscribeConferenceCreated>) o -> apply_unsub(o, o.conferenceAlias));
        unsubscribe_call.put(SubscribeConferenceEnded.class, (Call<SubscribeConferenceEnded>) o -> apply_unsub(o, o.conferenceAlias));
        unsubscribe_call.put(SubscribeParticipantJoined.class, (Call<SubscribeParticipantJoined>) o -> apply_unsub(o, o.conferenceAlias));
        unsubscribe_call.put(SubscribeParticipantLeft.class, (Call<SubscribeParticipantLeft>) o -> apply_unsub(o, o.conferenceAlias));
        unsubscribe_call.put(SubscribeInvitation.class, (Call<SubscribeInvitation>) o -> subscribe_invitations = false);
    }

    private void apply_sub(BaseSubscription o, String filter) {
        CopyOnWriteArrayList<String> map = subscribed_maps.get(o.getClass());
        if (null == map) {
            map = new CopyOnWriteArrayList<>();
            subscribed_maps.put(o.getClass(), map);
        }

        if (!map.contains(filter))
            map.add(filter);
    }

    private void apply_unsub(BaseSubscription o, String filter) {
        CopyOnWriteArrayList<String> map = subscribed_maps.get(o.getClass());
        if (null == map) {
            map = new CopyOnWriteArrayList<>();
            subscribed_maps.put(o.getClass(), map);
        }

        map.remove(filter);
    }


    public void onEvent(@NonNull ConferenceCreatedNotificationEvent event) {
        Opt<CopyOnWriteArrayList<String>> def = Opt.of(subscribed_maps.get(SubscribeConferenceCreated.class));
        if (def.then(m -> m.contains(event.conferenceAlias)).or(false))
            EventBus.getDefault().post(event);
    }

    public void onEvent(@NonNull ConferenceEndedNotificationEvent event) {
        Opt<CopyOnWriteArrayList<String>> def = Opt.of(subscribed_maps.get(SubscribeConferenceEnded.class));
        if (def.then(m -> m.contains(event.conferenceAlias)).or(false))
            EventBus.getDefault().post(event);
    }

    public void onEvent(@NonNull ParticipantJoinedNotificationEvent event) {
        Opt<CopyOnWriteArrayList<String>> def = Opt.of(subscribed_maps.get(SubscribeParticipantJoined.class));
        if (def.then(m -> m.contains(event.conferenceAlias)).or(false))
            EventBus.getDefault().post(event);
    }

    public void onEvent(@NonNull ParticipantLeftNotificationEvent event) {
        Opt<CopyOnWriteArrayList<String>> def = Opt.of(subscribed_maps.get(SubscribeParticipantLeft.class));
        if (def.then(m -> m.contains(event.conferenceAlias)).or(false))
            EventBus.getDefault().post(event);
    }

    public void onEvent(@NonNull InvitationReceivedNotificationEvent event) {
        if (subscribe_invitations)
            EventBus.getDefault().post(event);
        else
            Log.d(TAG, "onEvent: Invitation Received forward canceled : not subscribe_invitations flag");
    }

    public void subscribe(@NonNull BaseSubscription subscribe) {
        Call call = subscribe_call.get(subscribe.getClass());
        if (null != call) call.call(subscribe);
    }

    public void unsubscribe(@NonNull BaseSubscription subscribe) {
        Call call = unsubscribe_call.get(subscribe.getClass());
        if (null != call) call.call(subscribe);
    }

    private interface Call<PARAM> {
        void call(PARAM param);
    }
}
