/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.push.center;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.voxeet.sdk.push.center.invitation.IIncomingInvitationListener;
import com.voxeet.sdk.push.center.invitation.InvitationBundle;
import com.voxeet.sdk.push.center.management.EnforcedNotificationMode;
import com.voxeet.sdk.push.center.management.NotificationMode;
import com.voxeet.sdk.push.center.management.PushConferenceDestroyed;
import com.voxeet.sdk.push.center.management.VersionFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.greenrobot.eventbus.EventBus;

public class NotificationCenterFactory {
    private static final String TAG = NotificationCenterFactory.class.getSimpleName();
    public static NotificationCenterFactory instance = new NotificationCenterFactory();
    private Map<NotificationMode, Holder> invitationProviderForModes = new HashMap<NotificationMode, Holder>();
    @NonNull
    private EnforcedNotificationMode enforcedNotificationMode = EnforcedNotificationMode.FULLSCREEN_INCOMING_CALL;

    private NotificationCenterFactory() {
        this.invitationProviderForModes.put(NotificationMode.NONE, new Holder());
    }

    public boolean manageRemoteMessage(@NonNull Context context, @NonNull Map<String, String> remoteMessage) {
        if (remoteMessage.containsKey("NotifType")) {
            String notificationType = remoteMessage.get("NotifType");
            if (null == notificationType || TextUtils.isEmpty((CharSequence)notificationType)) {
                notificationType = "";
            }
            switch (notificationType) {
                case "1": {
                    this.onInvitationReceived(context, remoteMessage, Build.MANUFACTURER, Build.VERSION.SDK_INT);
                    break;
                }
                case "5": {
                    String conferenceId = this.onInvitationCanceledReceived(context, remoteMessage, Build.MANUFACTURER, Build.VERSION.SDK_INT);
                    EventBus.getDefault().post((Object)new PushConferenceDestroyed(conferenceId));
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public NotificationCenterFactory setEnforcedNotificationMode(@NonNull EnforcedNotificationMode enforcedNotificationMode) {
        this.enforcedNotificationMode = enforcedNotificationMode;
        return this;
    }

    public NotificationCenterFactory register(@NonNull NotificationMode notificationMode, @Nullable IIncomingInvitationListener invitationProvider) {
        Holder holder = this.invitationProviderForModes.get((Object)notificationMode);
        if (holder == null) {
            holder = new Holder();
            this.invitationProviderForModes.put(notificationMode, holder);
        }
        holder.invitationHolder = invitationProvider;
        return this;
    }

    public NotificationCenterFactory register(@NonNull NotificationMode notificationMode, @NonNull VersionFilter filter) {
        Holder holder = this.invitationProviderForModes.get((Object)notificationMode);
        if (holder == null) {
            holder = new Holder();
            this.invitationProviderForModes.put(notificationMode, holder);
        }
        if (!holder.filters.contains(filter)) {
            holder.filters.add(filter);
        }
        return this;
    }

    @Nullable
    private IIncomingInvitationListener getIncomingInvitation(@NonNull String manufacturer, int systemAPIVersion) {
        for (NotificationMode notificationMode : this.enforcedNotificationMode.getModes()) {
            Holder holder = this.invitationProviderForModes.get((Object)notificationMode);
            if (null == holder || holder.mustFilter(manufacturer, systemAPIVersion)) continue;
            return holder.invitationHolder;
        }
        return null;
    }

    public void onInvitationReceived(@NonNull Context context, @NonNull Map<String, String> remoteMessage, @NonNull String manufacturer, int systemAPIVersion) {
        IIncomingInvitationListener listener = this.getIncomingInvitation(manufacturer, systemAPIVersion);
        if (null != listener) {
            InvitationBundle invitationBundle = new InvitationBundle(remoteMessage);
            listener.onInvitation(context, invitationBundle);
        }
    }

    @NonNull
    public String onInvitationCanceledReceived(@NonNull Context context, @NonNull Map<String, String> remoteMessage, @NonNull String manufacturer, int systemAPIVersion) {
        IIncomingInvitationListener listener;
        String conferenceId = "";
        if (remoteMessage.containsKey("ConfId")) {
            conferenceId = remoteMessage.get("ConfId");
        }
        if (null == conferenceId || TextUtils.isEmpty((CharSequence)conferenceId)) {
            conferenceId = "";
        }
        if (null != (listener = this.getIncomingInvitation(manufacturer, systemAPIVersion))) {
            InvitationBundle invitationBundle = new InvitationBundle(remoteMessage);
            listener.onInvitationCanceled(context, conferenceId);
        }
        return conferenceId;
    }

    private class Holder {
        @Nullable
        IIncomingInvitationListener invitationHolder;
        @NonNull
        public List<VersionFilter> filters = new CopyOnWriteArrayList<VersionFilter>();

        private Holder() {
        }

        public boolean mustFilter(@NonNull String manufacturer, int systemAPIVersion) {
            for (VersionFilter filter : this.filters) {
                if (!filter.mustFilter(manufacturer, systemAPIVersion)) continue;
                return true;
            }
            return false;
        }
    }
}

