/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.push.center.invitation;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.push.utils.Annotate;
import java.util.HashMap;
import java.util.Map;

@Annotate
public class InvitationBundle {
    @Nullable
    public String inviterName;
    @Nullable
    public String inviterId;
    @Nullable
    public String inviterExternalId;
    @Nullable
    public String conferenceId;
    @Nullable
    public String inviterAvatarUrl;

    public InvitationBundle(@Nullable String inviterId, @Nullable String inviterName, @Nullable String inviterExternalId, @Nullable String conferenceId, @Nullable String inviterAvatarUrl) {
        this.inviterId = inviterId;
        this.inviterExternalId = inviterExternalId;
        this.conferenceId = conferenceId;
        this.inviterAvatarUrl = inviterAvatarUrl;
        this.inviterName = inviterName;
    }

    public InvitationBundle(@NonNull Bundle bundle) {
        this.inviterId = bundle.getString("UserId", null);
        this.inviterExternalId = bundle.getString("ExternalId", null);
        this.conferenceId = bundle.getString("ConfId", null);
        this.inviterAvatarUrl = bundle.getString("AvatarUrl", null);
        this.inviterName = bundle.getString("DisplayName", null);
    }

    public InvitationBundle(@NonNull Map<String, String> remoteMessage) {
        this.inviterId = this.get(remoteMessage, "UserId");
        this.inviterExternalId = this.get(remoteMessage, "ExternalId");
        this.conferenceId = this.get(remoteMessage, "ConfId");
        this.inviterAvatarUrl = this.get(remoteMessage, "AvatarUrl");
        this.inviterName = this.get(remoteMessage, "DisplayName");
    }

    @Nullable
    private String get(@NonNull Map<String, String> map, @NonNull String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    @NonNull
    public Map<String, String> asMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (null != this.conferenceId) {
            map.put("ConfId", this.conferenceId);
        }
        if (null != this.inviterExternalId) {
            map.put("ExternalId", this.inviterExternalId);
        }
        if (null != this.inviterId) {
            map.put("UserId", this.inviterId);
        }
        if (null != this.inviterName) {
            map.put("DisplayName", this.inviterName);
        }
        if (null != this.inviterAvatarUrl) {
            map.put("AvatarUrl", this.inviterAvatarUrl);
        }
        return map;
    }

    @NonNull
    public Bundle asBundle() {
        Bundle bundle = new Bundle();
        bundle.putString("ConfId", this.conferenceId);
        bundle.putString("ExternalId", this.inviterExternalId);
        bundle.putString("UserId", this.inviterId);
        bundle.putString("DisplayName", this.inviterName);
        bundle.putString("AvatarUrl", this.inviterAvatarUrl);
        return bundle;
    }
}

