package com.voxeet.push.center.invitation;

import android.content.Context;
import android.support.annotation.NonNull;

import com.voxeet.push.utils.Annotate;

/**
 * The IIncomingInvitationListener model implements and manages two types of invitations:
 * - The invitation [received](/documentation/sdk/reference/android/models/iincominginvitationlistener#oninvitattion) at the application level.
 * - The invitation to a call that is [canceled](/documentation/sdk/reference/android/models/iincominginvitationlistener#oninvitationcanceled) because all conference participants left the conference or the conference was canceled on a server or other side level.
 */
@Annotate
public interface IIncomingInvitationListener {

    /**
     * A method called by the SDK when the incoming invitation is received.
     * @param context The valid application context.
     * @param invitationBundle The underlying invitation.
     */
    void onInvitation(@NonNull Context context, @NonNull InvitationBundle invitationBundle);

    /**
     * A method called by the SDK when an invitation is canceled.
     * @param context The valid application context.
     * @param conferenceId The ID of the cancelled conference.
     */
    void onInvitationCanceled(@NonNull Context context, @NonNull String conferenceId);
}
