package com.voxeet.push.center.invitation;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.push.center.management.Constants;
import com.voxeet.push.utils.Annotate;

import java.util.HashMap;
import java.util.Map;

@Annotate
public class InvitationBundle {

    @Nullable
    public String inviterName;

    @Nullable
    public String inviterId;

    @Nullable
    public String inviterExternalId;

    @Nullable
    public String conferenceId;

    @Nullable
    public String inviterAvatarUrl;

    public InvitationBundle(@Nullable String inviterId, @Nullable String inviterName, @Nullable String inviterExternalId, @Nullable String conferenceId, @Nullable String inviterAvatarUrl) {
        this.inviterId = inviterId;
        this.inviterExternalId = inviterExternalId;
        this.conferenceId = conferenceId;
        this.inviterAvatarUrl = inviterAvatarUrl;
        this.inviterName = inviterName;
    }

    public InvitationBundle(@NonNull Bundle bundle) {
        this.inviterId = bundle.getString(Constants.INVITER_ID, null);
        this.inviterExternalId = bundle.getString(Constants.INVITER_EXTERNAL_ID, null);
        this.conferenceId = bundle.getString(Constants.CONF_ID, null);
        this.inviterAvatarUrl = bundle.getString(Constants.INVITER_URL, null);
        this.inviterName = bundle.getString(Constants.INVITER_NAME, null);
    }

    public InvitationBundle(@NonNull Map<String, String> remoteMessage) {
        this.inviterId = get(remoteMessage, Constants.INVITER_ID);
        this.inviterExternalId = get(remoteMessage, Constants.INVITER_EXTERNAL_ID);
        this.conferenceId = get(remoteMessage, Constants.CONF_ID);
        this.inviterAvatarUrl = get(remoteMessage, Constants.INVITER_URL);
        this.inviterName = get(remoteMessage, Constants.INVITER_NAME);
    }

    @Nullable
    private String get(@NonNull Map<String, String> map, @NonNull String key) {
        if (map.containsKey(key)) return map.get(key);
        return null;
    }

    @NonNull
    public Map<String, String> asMap() {
        Map<String, String> map = new HashMap<>();
        if (null != conferenceId) map.put(Constants.CONF_ID, conferenceId);
        if (null != inviterExternalId) map.put(Constants.INVITER_EXTERNAL_ID, inviterExternalId);
        if (null != inviterId) map.put(Constants.INVITER_ID, inviterId);
        if (null != inviterName) map.put(Constants.INVITER_NAME, inviterName);
        if (null != inviterAvatarUrl) map.put(Constants.INVITER_URL, inviterAvatarUrl);
        return map;
    }

    @NonNull
    public Bundle asBundle() {
        Bundle bundle = new Bundle();
        bundle.putString(Constants.CONF_ID, conferenceId);
        bundle.putString(Constants.INVITER_EXTERNAL_ID, inviterExternalId);
        bundle.putString(Constants.INVITER_ID, inviterId);
        bundle.putString(Constants.INVITER_NAME, inviterName);
        bundle.putString(Constants.INVITER_URL, inviterAvatarUrl);
        return bundle;
    }
}
