/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.push.firebase;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.google.firebase.iid.FirebaseInstanceId;
import com.voxeet.push.utils.Annotate;

@Annotate
public class FirebaseController {
    private static final FirebaseController _sinstance = new FirebaseController();
    private static final String SDK_CHANNEL_ID = "voxeet_sdk_channel_id";
    private static final String SDK_CHANNEL_NAME = "voxeet_sdk_channel_name";
    private static final String SDK_CHANNEL_DESCRIPTION = "voxeet_sdk_channel_description";
    private static final String SDK_CHANNEL_COLOR = "voxeet_sdk_channel_color";
    private static final String DEFAULT_ID = "VideoConference";
    private static final String DEFAULT_NAME = "Video Conference";
    private static final String DEFAULT_DESCRIPTION = "Incoming calls are managed here";
    private static final int DEFAULT_COLOR = -1;
    private static boolean ChannelSet = false;
    private boolean _enabled = false;
    private boolean _can_log = false;

    public static final FirebaseController getInstance() {
        return _sinstance;
    }

    private FirebaseController() {
    }

    public FirebaseController enable(boolean is_enable) {
        this._enabled = is_enable;
        return this;
    }

    public FirebaseController log(boolean can_log) {
        this._can_log = can_log;
        return this;
    }

    public boolean isTokenUploadAllowed() {
        return this._enabled;
    }

    public FirebaseController log(@NonNull String string) {
        if (this._can_log) {
            Log.d((String)this.getClass().getSimpleName(), (String)string);
        }
        return this;
    }

    public String getToken() {
        try {
            return FirebaseInstanceId.getInstance().getToken();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getChannelId(@NonNull Context context) {
        return FirebaseController.readMetadata(context, SDK_CHANNEL_ID, DEFAULT_ID);
    }

    public static boolean createNotificationChannel(@NonNull Context context) {
        return FirebaseController.createNotificationChannel(context, FirebaseController.readMetadata(context, SDK_CHANNEL_ID, DEFAULT_ID), FirebaseController.readMetadata(context, SDK_CHANNEL_NAME, DEFAULT_NAME), FirebaseController.readMetadata(context, SDK_CHANNEL_DESCRIPTION, DEFAULT_DESCRIPTION), FirebaseController.readMetadataInt(context, SDK_CHANNEL_COLOR, -1));
    }

    public static boolean createNotificationChannel(@NonNull Context context, @NonNull String id, @NonNull CharSequence name, @NonNull String description, int argb) {
        if (Build.VERSION.SDK_INT < 26) {
            return true;
        }
        if (ChannelSet) {
            return false;
        }
        NotificationManager mNotificationManager = (NotificationManager)context.getSystemService("notification");
        int importance = 4;
        NotificationChannel channel = new NotificationChannel(id, name, importance);
        channel.setDescription(description);
        channel.enableLights(true);
        channel.setLightColor(argb);
        channel.enableVibration(true);
        channel.setVibrationPattern(new long[]{100L, 200L});
        channel.setLockscreenVisibility(0);
        if (null != mNotificationManager) {
            mNotificationManager.createNotificationChannel(channel);
            ChannelSet = true;
        }
        return true;
    }

    private static int readMetadataInt(@NonNull Context context, @NonNull String key, int argb) {
        try {
            String metaData = FirebaseController.readMetadata(context, key, null);
            if (!TextUtils.isEmpty((CharSequence)metaData)) {
                return Integer.parseInt(metaData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return argb;
    }

    private static String readMetadata(@NonNull Context context, @NonNull String key, @NonNull String def) {
        ApplicationInfo appInfo = null;
        try {
            appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = appInfo.metaData;
            String value = bundle.getString(key);
            if (!TextUtils.isEmpty((CharSequence)value)) {
                return value;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return def;
    }
}

