package com.voxeet.push.center.management;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.push.utils.Annotate;

@Annotate
public class VersionFilter {

    public final static String ALL = null;

    @Nullable
    public String manufacturer;

    public int minimumAPIVersion;

    public VersionFilter(String manufacturer, int minimumAPIVersion) {
        this.manufacturer = manufacturer;
        this.minimumAPIVersion = minimumAPIVersion;
    }

    public boolean mustFilter(@NonNull String manufacturer, int systemAPIVersion) {
        if(minimumAPIVersion > systemAPIVersion) return false;
        if(null == this.manufacturer) return true;
        return manufacturer.equalsIgnoreCase(this.manufacturer);
    }
}
