package com.voxeet.push.firebase;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;

import com.google.firebase.messaging.RemoteMessage;

import org.greenrobot.eventbus.EventBus;

import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.factories.VoxeetIntentFactory;
import com.voxeet.sdk.json.ConferenceDestroyedPush;

public class VoxeetManageRemoteMessage {

    private static final String NOTIF_TYPE_INVITATION_RECEIVED = "1";
    private static final String NOTIF_TYPE_CONTACT_SUBSCRIPTION_RECEIVED = "2";
    private static final String NOTIF_TYPE_OWN_EVENTS_CLEARED = "3";
    private static final String NOTIF_TYPE_OWN_ACTIVITIES_CLEARED = "4";
    private static final String NOTIF_TYPE_LOCAL_CONFERENCE_DESTROYED = "5";
    private static final String NOTIF_TYPE_OWN_CONFERENCE_CREATED = "6";
    private static final String NOTIF_TYPE_CONTACTS_SUGGESTION = "7";
    private static final String NOTIF_TYPE_MESSAGE_RECEIVED = "8";

    public static boolean tryManage(@NonNull Context context,
                                    @NonNull EventBus eventBus,
                                    @NonNull RemoteMessage remoteMessage) {

        if (remoteMessage.getData().containsKey(VoxeetIntentFactory.NOTIF_TYPE)) {
            if (remoteMessage.getData().get(VoxeetIntentFactory.NOTIF_TYPE).equalsIgnoreCase(NOTIF_TYPE_INVITATION_RECEIVED)) {
                Intent intent = VoxeetIntentFactory.buildFrom(context, VoxeetPreferences.getDefaultActivity(), remoteMessage.getData());
                if (intent != null)
                    context.startActivity(intent);
            } else if (remoteMessage.getData().get(VoxeetIntentFactory.NOTIF_TYPE).equalsIgnoreCase(NOTIF_TYPE_LOCAL_CONFERENCE_DESTROYED)) {
                eventBus.post(new ConferenceDestroyedPush());
            }
            return true;
        }
        return false;
    }

}
