/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.telemetry.network;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.telephony.TelephonyManager;
import com.voxeet.sdk.services.telemetry.network.CarrierInfo;
import com.voxeet.sdk.services.telemetry.network.CarrierProvider;
import com.voxeet.sdk.services.telemetry.network.carriers.CarrierProvider16;
import com.voxeet.sdk.services.telemetry.network.carriers.CarrierProviderPre16;
import com.voxeet.sdk.services.telemetry.network.wifi.Wifi;
import com.voxeet.sdk.utils.Opt;
import java.util.List;

public class NetworkInformationProvider {
    private CarrierProvider carrierProvider;
    @NonNull
    private TelephonyManager telephonyManager;
    @NonNull
    private WifiManager wifiManager;

    private NetworkInformationProvider() {
    }

    public NetworkInformationProvider(@NonNull Context context) {
        this.wifiManager = (WifiManager)context.getSystemService("wifi");
        this.telephonyManager = (TelephonyManager)context.getSystemService("phone");
        this.carrierProvider = Build.VERSION.SDK_INT >= 22 ? new CarrierProvider16(context) : new CarrierProviderPre16(context);
    }

    @Nullable
    public Wifi wifiInfo() {
        return (Wifi)Opt.of((Object)this.wifiManager).then(WifiManager::getConnectionInfo).then(Wifi::new).orNull();
    }

    @NonNull
    public List<CarrierInfo> carriers() {
        return this.carrierProvider.carriers();
    }
}

