/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.telemetry.device;

import android.os.Build;
import android.support.annotation.NonNull;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.voxeet.audio2.devices.MediaDevice;
import com.voxeet.sdk.services.telemetry.SdkEnvironment;
import com.voxeet.sdk.services.telemetry.codec.Codec;
import com.voxeet.sdk.services.telemetry.device.HardwareInfo;
import com.voxeet.sdk.services.telemetry.network.CarrierInfo;
import com.voxeet.sdk.services.telemetry.network.wifi.Wifi;
import com.voxeet.sdk.utils.Map;
import com.voxeet.sdk.utils.Opt;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DeviceInformation {
    public String name;
    public String os;
    public String timeZone;
    public String sdkPlatform;
    public String sdkVersion;
    public String uxkitVersion;
    public Hardware hardware;
    public HashMap<String, String> versions;
    public Device extended;

    private DeviceInformation(@NonNull HardwareInfo info) {
        this.name = info.deviceName();
        this.os = info.os();
        this.timeZone = info.tz();
        this.hardware = new Hardware(info.cpu(), "" + info.ram(), String.format(Locale.getDefault(), "%dx%d", info.width(), info.height()));
    }

    public DeviceInformation(@NonNull HardwareInfo info, boolean full, @NonNull ConcurrentHashMap<SdkEnvironment, String> environment, List<MediaDevice> mediaDevices) {
        this(info);
        this.hardware.codecs = Codec.list();
        if (full) {
            this.extended = new Device(Codec.list(), info, mediaDevices);
            this.versions = new HashMap();
            for (SdkEnvironment key : environment.keySet()) {
                this.versions.put(key.name, environment.get((Object)key));
            }
        }
        Opt opt = Opt.of(environment);
        this.sdkVersion = (String)opt.then(v -> (String)v.get((Object)SdkEnvironment.SDK)).or((Object)"");
        this.sdkPlatform = (String)opt.then(v -> (String)v.get((Object)SdkEnvironment.CORDOVA)).or(opt.then(v -> (String)v.get((Object)SdkEnvironment.REACT_NATIVE)).or((Object)this.sdkVersion));
        this.uxkitVersion = (String)opt.then(v -> (String)v.get((Object)SdkEnvironment.UXKIT)).orNull();
    }

    public DeviceInformation(@NonNull HardwareInfo info, boolean full, @NonNull ConcurrentHashMap<SdkEnvironment, String> environment, List<MediaDevice> mediaDevices, List<CarrierInfo> carriers, Wifi wifi) {
        this(info, full, environment, mediaDevices);
        if (null != this.extended) {
            this.extended.networks = new Networks(carriers, wifi);
        }
    }

    public class Device {
        public List<MediaDeviceJson> peripherals;
        public String model;
        public String manufacturer;
        public String os = "android";
        public long version = Build.VERSION.SDK_INT;
        public String brand = Build.BRAND.toLowerCase();
        public String board = Build.BOARD;
        public List<Codec> codecs;
        public Networks networks;
        public Screen screen;

        public Device() {
            this.manufacturer = Build.MANUFACTURER;
            this.model = Build.MODEL;
        }

        public Device(List<Codec> codecs, HardwareInfo info, List<MediaDevice> mediaDevices) {
            this();
            this.codecs = codecs;
            this.screen = new Screen(info);
            this.peripherals = Map.map(mediaDevices, x$0 -> new MediaDeviceJson((MediaDevice)x$0));
        }

        public class Screen {
            public long width;
            public long height;

            public Screen(HardwareInfo info) {
                this.width = info.width();
                this.height = info.height();
            }
        }

        public class MediaDeviceJson {
            public String name;
            public String type;

            public MediaDeviceJson(MediaDevice device) {
                this.name = device.id();
                this.type = device.deviceType().toString().toLowerCase();
            }
        }
    }

    public class Hardware {
        public String cpu;
        public String ram;
        public String screen;
        public List<Codec> codecs;

        public Hardware(String cpu, String ram, String screen) {
            this.cpu = cpu;
            this.ram = ram;
            this.screen = screen;
        }
    }

    public class Networks {
        public List<CarrierInfo> carriers;
        public Wifi wifi;

        public Networks(List<CarrierInfo> carriers, Wifi wifi) {
            this.carriers = carriers;
            this.wifi = wifi;
        }
    }
}

